/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.udflib.handler;

import com.github.stephenc.javaisotools.sabre.ContentHandler;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Element;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StructureHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteArrayDataReference;
import com.github.stephenc.javaisotools.sabre.impl.ChainingStreamHandler;
import com.github.stephenc.javaisotools.udflib.SabreUDFElement;
import com.github.stephenc.javaisotools.udflib.structures.Tag;
import com.github.stephenc.javaisotools.udflib.tools.BinaryTools;
import com.github.stephenc.javaisotools.udflib.tools.Checksum;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

public class DescriptorTagHandler
extends ChainingStreamHandler {
    protected Stack<Element> elementStack = new Stack();
    protected Stack<DataReference> dataReferenceStack = new Stack();

    public DescriptorTagHandler(StructureHandler myStructureHandler, ContentHandler myContentHandler) {
        super(myStructureHandler, myContentHandler);
    }

    @Override
    public void startElement(Element myElement) throws HandlerException {
        this.elementStack.push(myElement);
        super.startElement(myElement);
    }

    @Override
    public void endElement() throws HandlerException {
        Element myElement = this.elementStack.pop();
        if (myElement.getId() == SabreUDFElement.UDFElementType.DescriptorTag) {
            this.createAndPassDescriptorTag();
        }
        super.endElement();
    }

    private void createAndPassDescriptorTag() throws HandlerException {
        InputStream myInputStream = null;
        Tag descriptorTag = new Tag();
        byte[] payload = new byte[]{};
        try {
            DataReference myDataReference = this.dataReferenceStack.pop();
            myInputStream = myDataReference.createInputStream();
            payload = BinaryTools.readByteArray(myInputStream, (int)myDataReference.getLength());
            myInputStream.close();
            myInputStream = null;
            myInputStream = this.dataReferenceStack.pop().createInputStream();
            descriptorTag.DescriptorVersion = (int)BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            myInputStream = this.dataReferenceStack.pop().createInputStream();
            descriptorTag.TagSerialNumber = (int)BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            myInputStream = this.dataReferenceStack.pop().createInputStream();
            descriptorTag.TagLocation = BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
            myInputStream = this.dataReferenceStack.pop().createInputStream();
            descriptorTag.TagIdentifier = (int)BinaryTools.readUInt32AsLong(myInputStream);
            myInputStream.close();
            myInputStream = null;
        }
        catch (IOException myIOException) {
            throw new HandlerException(myIOException);
        }
        finally {
            if (myInputStream != null) {
                try {
                    myInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        descriptorTag.DescriptorCRCLength = payload.length;
        descriptorTag.DescriptorCRC = Checksum.cksum(payload);
        super.data(new ByteArrayDataReference(descriptorTag.getBytes()));
        super.data(new ByteArrayDataReference(payload));
    }

    @Override
    public void data(DataReference myDataReference) throws HandlerException {
        if (this.elementStack.size() != 0 && this.elementStack.peek().getId() == SabreUDFElement.UDFElementType.DescriptorTag) {
            this.dataReferenceStack.push(myDataReference);
        } else {
            super.data(myDataReference);
        }
    }
}

