/*
 * Decompiled with CFR 0.152.
 */
package com.github.stanfordfuturedata.momentsketch.optimizer;

import com.github.stanfordfuturedata.momentsketch.optimizer.FunctionWithHessian;

public class QuadraticPotential
implements FunctionWithHessian {
    private int k;
    private double Pval;
    private double[] Pgrad;
    private double[][] Phess;

    public QuadraticPotential(int k) {
        this.k = k;
        this.Pgrad = new double[k];
        this.Phess = new double[k][k];
    }

    @Override
    public void computeOnlyValue(double[] point, double tol) {
        double sum = 0.0;
        for (int i = 0; i < point.length; ++i) {
            sum += point[i] * point[i];
        }
        this.Pval = sum;
    }

    @Override
    public void computeAll(double[] point, double tol) {
        int i;
        double sum = 0.0;
        for (i = 0; i < point.length; ++i) {
            sum += point[i] * point[i];
        }
        this.Pval = sum;
        for (i = 0; i < point.length; ++i) {
            this.Pgrad[i] = 2.0 * point[i];
            for (int j = 0; j < point.length; ++j) {
                this.Phess[i][j] = j == i ? 2.0 : 0.0;
            }
        }
    }

    @Override
    public int dim() {
        return this.k;
    }

    @Override
    public double getValue() {
        return this.Pval;
    }

    @Override
    public double[] getGradient() {
        return this.Pgrad;
    }

    @Override
    public double[][] getHessian() {
        return this.Phess;
    }
}

