/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;

public class FreeMarkerRender
extends Render {
    private static final String encoding = FreeMarkerRender.getEncoding();
    private static final String contentType = "text/html; charset=" + encoding;
    private static final Version FREEMARKER_VERSION = Configuration.getVersion();
    private static final Configuration config = new Configuration(FREEMARKER_VERSION);

    public FreeMarkerRender(String view) {
        this.view = view;
    }

    public static Configuration getConfiguration() {
        return config;
    }

    public static void setProperty(String propertyName, String propertyValue) {
        try {
            FreeMarkerRender.getConfiguration().setSetting(propertyName, propertyValue);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setProperties(Properties properties) {
        try {
            FreeMarkerRender.getConfiguration().setSettings(properties);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    static void init(ServletContext servletContext, Locale locale, int template_update_delay) {
        config.setServletContextForTemplateLoading((Object)servletContext, "/");
        if (FreeMarkerRender.getDevMode()) {
            config.setTemplateUpdateDelay(0);
        } else {
            config.setTemplateUpdateDelay(template_update_delay);
        }
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setObjectWrapper((ObjectWrapper)new BeansWrapperBuilder(FREEMARKER_VERSION).build());
        config.setDefaultEncoding(encoding);
        config.setOutputEncoding(encoding);
        config.setLocale(locale);
        config.setLocalizedLookup(false);
        config.setNumberFormat("#0.#####");
        config.setDateFormat("yyyy-MM-dd");
        config.setTimeFormat("HH:mm:ss");
        config.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public void render() {
        this.response.setContentType(contentType);
        HashMap<String, Object> root = new HashMap<String, Object>();
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            root.put(attrName, this.request.getAttribute(attrName));
        }
        PrintWriter writer = null;
        try {
            Template template = config.getTemplate(this.view);
            writer = this.response.getWriter();
            template.process(root, (Writer)writer);
        }
        catch (Exception e) {
            throw new RenderException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

