/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.kit.PathKit;
import com.jfinal.kit.StrKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletContext;

public class FileRender
extends Render {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private File file;
    private String fileName;
    private static String fileDownloadPath;
    private static ServletContext servletContext;
    private static String webRootPath;

    public FileRender(File file) {
        this.file = file;
    }

    public FileRender(String fileName) {
        this.fileName = fileName;
    }

    static void init(String fileDownloadPath, ServletContext servletContext) {
        FileRender.fileDownloadPath = fileDownloadPath;
        FileRender.servletContext = servletContext;
        webRootPath = PathKit.getWebRootPath();
    }

    @Override
    public void render() {
        if (this.fileName != null) {
            this.file = this.fileName.startsWith("/") ? new File(webRootPath + this.fileName) : new File(fileDownloadPath + this.fileName);
        }
        if (this.file == null || !this.file.isFile()) {
            RenderFactory.me().getErrorRender(404).setContext(this.request, this.response).render();
            return;
        }
        this.response.setHeader("Accept-Ranges", "bytes");
        this.response.setHeader("Content-disposition", "attachment; filename=" + this.encodeFileName(this.file.getName()));
        String contentType = servletContext.getMimeType(this.file.getName());
        this.response.setContentType(contentType != null ? contentType : DEFAULT_CONTENT_TYPE);
        if (StrKit.isBlank(this.request.getHeader("Range"))) {
            this.normalRender();
        } else {
            this.rangeRender();
        }
    }

    private String encodeFileName(String fileName) {
        try {
            return new String(fileName.getBytes("GBK"), "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return fileName;
        }
    }

    private void normalRender() {
        this.response.setHeader("Content-Length", String.valueOf(this.file.length()));
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(this.file));
            outputStream = this.response.getOutputStream();
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            if (FileRender.getDevMode()) {
                throw new RenderException(e);
            }
        }
        catch (Exception e) {
            throw new RenderException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void rangeRender() {
        Long[] range = new Long[]{null, null};
        this.processRange(range);
        String contentLength = String.valueOf(range[1] - range[0] + 1L);
        this.response.setHeader("Content-Length", contentLength);
        this.response.setStatus(206);
        StringBuilder contentRange = new StringBuilder("bytes ").append(String.valueOf(range[0])).append("-").append(String.valueOf(range[1])).append("/").append(String.valueOf(this.file.length()));
        this.response.setHeader("Content-Range", contentRange.toString());
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int len;
            long start = range[0];
            long end = range[1];
            inputStream = new BufferedInputStream(new FileInputStream(this.file));
            if (inputStream.skip(start) != start) {
                throw new RuntimeException("File skip error");
            }
            outputStream = this.response.getOutputStream();
            byte[] buffer = new byte[1024];
            long position = start;
            while (position <= end && (len = inputStream.read(buffer)) != -1) {
                if (position + (long)len <= end) {
                    outputStream.write(buffer, 0, len);
                    position += (long)len;
                    continue;
                }
                for (int i = 0; i < len && position <= end; ++position, ++i) {
                    outputStream.write(buffer[i]);
                }
            }
            outputStream.flush();
        }
        catch (IOException e) {
            if (FileRender.getDevMode()) {
                throw new RenderException(e);
            }
        }
        catch (Exception e) {
            throw new RenderException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void processRange(Long[] range) {
        String[] arr;
        String rangeStr = this.request.getHeader("Range");
        int index = rangeStr.indexOf(44);
        if (index != -1) {
            rangeStr = rangeStr.substring(0, index);
        }
        if ((arr = (rangeStr = rangeStr.replace("bytes=", "")).split("-", 2)).length < 2) {
            throw new RuntimeException("Range error");
        }
        long fileLength = this.file.length();
        for (int i = 0; i < range.length; ++i) {
            if (!StrKit.notBlank(arr[i])) continue;
            range[i] = Long.parseLong(arr[i].trim());
            if (range[i] < fileLength) continue;
            range[i] = fileLength - 1L;
        }
        if (range[0] != null && range[1] == null) {
            range[1] = fileLength - 1L;
        } else if (range[0] == null && range[1] != null) {
            range[0] = fileLength - range[1];
            range[1] = fileLength - 1L;
        }
        if (range[0] == null || range[1] == null || range[0] > range[1]) {
            throw new RuntimeException("Range error");
        }
    }
}

