/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.tx;

import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.NestedTransactionHelpException;
import com.jfinal.plugin.activerecord.tx.TxConfig;
import java.sql.Connection;
import java.sql.SQLException;

public class Tx
implements Interceptor {
    static Config getConfigWithTxConfig(ActionInvocation ai) {
        TxConfig txConfig = ai.getMethod().getAnnotation(TxConfig.class);
        if (txConfig == null) {
            txConfig = ai.getController().getClass().getAnnotation(TxConfig.class);
        }
        if (txConfig != null) {
            Config config = DbKit.getConfig(txConfig.value());
            if (config == null) {
                throw new RuntimeException("Config not found with TxConfig");
            }
            return config;
        }
        return null;
    }

    protected int getTransactionLevel(Config config) {
        return config.getTransactionLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void intercept(ActionInvocation ai) {
        Connection conn;
        Config config = Tx.getConfigWithTxConfig(ai);
        if (config == null) {
            config = DbKit.getConfig();
        }
        if ((conn = config.getThreadLocalConnection()) != null) {
            try {
                if (conn.getTransactionIsolation() < this.getTransactionLevel(config)) {
                    conn.setTransactionIsolation(this.getTransactionLevel(config));
                }
                ai.invoke();
                return;
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
        Boolean autoCommit = null;
        try {
            conn = config.getConnection();
            autoCommit = conn.getAutoCommit();
            config.setThreadLocalConnection(conn);
            conn.setTransactionIsolation(this.getTransactionLevel(config));
            conn.setAutoCommit(false);
            ai.invoke();
            conn.commit();
            return;
        }
        catch (NestedTransactionHelpException e) {
            if (conn == null) return;
            try {
                conn.rollback();
                return;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return;
            }
        }
        catch (Throwable t) {
            if (conn == null) throw new ActiveRecordException(t);
            try {
                conn.rollback();
                throw new ActiveRecordException(t);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            throw new ActiveRecordException(t);
        }
        finally {
            try {
                if (conn != null) {
                    if (autoCommit != null) {
                        conn.setAutoCommit(autoCommit);
                    }
                    conn.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                config.removeThreadLocalConnection();
            }
        }
    }
}

