/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.dialect;

import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Dialect {
    private static final Logger logger = LoggerFactory.getLogger(Dialect.class);

    public abstract String forTableBuilderDoBuild(String var1);

    public abstract void forModelSave(Table var1, Map<String, Object> var2, StringBuilder var3, List<Object> var4);

    public abstract String forModelDeleteById(Table var1);

    public abstract void forModelUpdate(Table var1, Map<String, Object> var2, Set<String> var3, String var4, Object var5, StringBuilder var6, List<Object> var7);

    public abstract String forModelFindById(Table var1, String var2);

    public abstract String forDbFindById(String var1, String var2, String var3);

    public abstract String forDbDeleteById(String var1, String var2);

    public abstract void forDbSave(StringBuilder var1, List<Object> var2, String var3, Record var4);

    public abstract void forDbUpdate(String var1, String var2, Object var3, Record var4, StringBuilder var5, List<Object> var6);

    public abstract void forPaginate(StringBuilder var1, int var2, int var3, String var4, String var5);

    public boolean isOracle() {
        return false;
    }

    public boolean isTakeOverDbPaginate() {
        return false;
    }

    public Page<Record> takeOverDbPaginate(Connection conn, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) throws SQLException {
        throw new RuntimeException("You should implements this method in " + this.getClass().getName());
    }

    public boolean isTakeOverModelPaginate() {
        return false;
    }

    public Page takeOverModelPaginate(Connection conn, Class<? extends Model> modelClass, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) throws Exception {
        throw new RuntimeException("You should implements this method in " + this.getClass().getName());
    }

    public void fillStatement(PreparedStatement pst, List<Object> paras) throws SQLException {
        boolean show_param = logger.isDebugEnabled();
        int param_size = paras.size();
        if (show_param) {
            logger.debug("Sql param size : {}", param_size == 0 ? " Empty" : Integer.valueOf(param_size));
            for (int i = 0; i < param_size; ++i) {
                Object param = paras.get(i);
                pst.setObject(i + 1, param);
                logger.debug("   param index: {}, param type: {}, param value: {}. ", new Object[]{i + 1, param == null ? "null" : param.getClass().getSimpleName(), param});
            }
            logger.debug("Sql param end!");
        } else {
            for (int i = 0; i < param_size; ++i) {
                pst.setObject(i + 1, paras.get(i));
            }
        }
    }

    public void fillStatement(PreparedStatement pst, Object ... paras) throws SQLException {
        boolean show_param = logger.isDebugEnabled();
        int param_size = paras.length;
        if (show_param) {
            logger.debug("Sql param size : {}", param_size == 0 ? " Empty" : Integer.valueOf(param_size));
            for (int i = 0; i < param_size; ++i) {
                Object param = paras[i];
                pst.setObject(i + 1, param);
                logger.debug("   param index: {}, param type: {}, param value: {}. ", new Object[]{i + 1, param == null ? "null" : param.getClass().getSimpleName(), param});
            }
            logger.debug("Sql param end!\n");
        } else {
            for (int i = 0; i < param_size; ++i) {
                pst.setObject(i + 1, paras[i]);
            }
        }
    }

    public String getDefaultPrimaryKey() {
        return "id";
    }
}

