/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;

class TableBuilder {
    TableBuilder() {
    }

    static boolean build(List<Table> tableList, Config config) {
        Table temp = null;
        Connection conn = null;
        try {
            conn = config.dataSource.getConnection();
            TableMapping tableMapping = TableMapping.me();
            Iterator<Table> i$ = tableList.iterator();
            while (i$.hasNext()) {
                Table table;
                temp = table = i$.next();
                TableBuilder.doBuild(table, conn, config);
                tableMapping.putTable(table);
                DbKit.addModelToConfigMapping(table.getModelClass(), config);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (temp != null) {
                System.err.println("Can not create Table object, maybe the table " + temp.getName() + " is not exists.");
            }
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    private static void doBuild(Table table, Connection conn, Config config) throws SQLException {
        table.setColumnTypeMap(config.containerFactory.getAttrsMap());
        if (table.getPrimaryKey() == null) {
            table.setPrimaryKey(config.dialect.getDefaultPrimaryKey());
        }
        String sql = config.dialect.forTableBuilderDoBuild(table.getName());
        Statement stm = conn.createStatement();
        ResultSet rs = stm.executeQuery(sql);
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String colName = rsmd.getColumnName(i).toLowerCase();
            String colClassName = rsmd.getColumnClassName(i);
            if ("java.lang.String".equals(colClassName)) {
                table.setColumnType(colName, String.class);
                continue;
            }
            if ("java.lang.Integer".equals(colClassName)) {
                table.setColumnType(colName, Integer.class);
                continue;
            }
            if ("java.lang.Long".equals(colClassName)) {
                table.setColumnType(colName, Long.class);
                continue;
            }
            if ("java.sql.Date".equals(colClassName)) {
                table.setColumnType(colName, Date.class);
                continue;
            }
            if ("java.lang.Double".equals(colClassName)) {
                table.setColumnType(colName, Double.class);
                continue;
            }
            if ("java.lang.Float".equals(colClassName)) {
                table.setColumnType(colName, Float.class);
                continue;
            }
            if ("java.lang.Boolean".equals(colClassName)) {
                table.setColumnType(colName, Boolean.class);
                continue;
            }
            if ("java.sql.Time".equals(colClassName)) {
                table.setColumnType(colName, Time.class);
                continue;
            }
            if ("java.sql.Timestamp".equals(colClassName)) {
                table.setColumnType(colName, Timestamp.class);
                continue;
            }
            if ("java.math.BigDecimal".equals(colClassName)) {
                table.setColumnType(colName, BigDecimal.class);
                continue;
            }
            if ("[B".equals(colClassName)) {
                table.setColumnType(colName, byte[].class);
                continue;
            }
            int type = rsmd.getColumnType(i);
            if (type == 2004) {
                table.setColumnType(colName, byte[].class);
                continue;
            }
            if (type == 2005 || type == 2011) {
                table.setColumnType(colName, String.class);
                continue;
            }
            table.setColumnType(colName, String.class);
        }
        rs.close();
        stm.close();
    }
}

