/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.sqlformat.SqlFormatter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlReporter
implements InvocationHandler {
    private final Connection conn;
    private static final Logger logger = LoggerFactory.getLogger(SqlReporter.class);

    SqlReporter(Connection conn) {
        this.conn = conn;
    }

    Connection getConnection() {
        Class<?> clazz = this.conn.getClass();
        return (Connection)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getName().equals("prepareStatement") && logger.isDebugEnabled() && DbKit.getConfig().isShowSql()) {
                logger.debug("The Exec Sql is: \r\n {} ", (Object)SqlFormatter.format(String.valueOf(args[0])));
            }
            return method.invoke((Object)this.conn, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

