/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.IContainerFactory;
import com.jfinal.plugin.activerecord.SqlReporter;
import com.jfinal.plugin.activerecord.cache.EhCache;
import com.jfinal.plugin.activerecord.cache.ICache;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.MysqlDialect;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class Config {
    String name;
    private final ThreadLocal<Connection> threadLocal = new ThreadLocal();
    DataSource dataSource;
    int transactionLevel = 2;
    ICache cache = new EhCache();
    boolean showSql = false;
    boolean devMode = false;
    Dialect dialect = new MysqlDialect();
    IContainerFactory containerFactory = new IContainerFactory(){

        @Override
        public Map<String, Object> getAttrsMap() {
            return new HashMap<String, Object>();
        }

        @Override
        public Map<String, Object> getColumnsMap() {
            return new HashMap<String, Object>();
        }

        @Override
        public Set<String> getModifyFlagSet() {
            return new HashSet<String>();
        }
    };

    Config() {
    }

    public Config(String name, DataSource dataSource) {
        if (StrKit.isBlank(name)) {
            throw new IllegalArgumentException("Config name can not be blank");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource can not be null");
        }
        this.name = name.trim();
        this.dataSource = dataSource;
    }

    public Config(String name, DataSource dataSource, Dialect dialect) {
        if (StrKit.isBlank(name)) {
            throw new IllegalArgumentException("Config name can not be blank");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource can not be null");
        }
        if (dialect == null) {
            throw new IllegalArgumentException("Dialect can not be null");
        }
        this.name = name.trim();
        this.dataSource = dataSource;
        this.dialect = dialect;
    }

    public Config(String name, DataSource dataSource, Dialect dialect, Boolean showSql, Boolean devMode, Integer transactionLevel, IContainerFactory containerFactory, ICache cache) {
        if (StrKit.isBlank(name)) {
            throw new IllegalArgumentException("Config name can not be blank");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource can not be null");
        }
        this.name = name.trim();
        this.dataSource = dataSource;
        if (dialect != null) {
            this.dialect = dialect;
        }
        if (showSql != null) {
            this.showSql = showSql;
        }
        if (devMode != null) {
            this.devMode = devMode;
        }
        if (transactionLevel != null) {
            this.transactionLevel = transactionLevel;
        }
        if (containerFactory != null) {
            this.containerFactory = containerFactory;
        }
        if (cache != null) {
            this.cache = cache;
        }
    }

    public String getName() {
        return this.name;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public ICache getCache() {
        return this.cache;
    }

    public int getTransactionLevel() {
        return this.transactionLevel;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public IContainerFactory getContainerFactory() {
        return this.containerFactory;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public final void setThreadLocalConnection(Connection connection) {
        this.threadLocal.set(connection);
    }

    public final void removeThreadLocalConnection() {
        this.threadLocal.remove();
    }

    public final Connection getConnection() throws SQLException {
        Connection conn = this.threadLocal.get();
        if (conn != null) {
            return conn;
        }
        return this.showSql ? new SqlReporter(this.dataSource.getConnection()).getConnection() : this.dataSource.getConnection();
    }

    public final Connection getThreadLocalConnection() {
        return this.threadLocal.get();
    }

    public final void close(ResultSet rs, Statement st, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    public final void close(Statement st, Connection conn) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }

    public final void close(Connection conn) {
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
    }
}

