/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class Prop {
    private Properties properties = null;

    public Prop(String fileName) {
        this(fileName, "UTF-8");
    }

    public Prop(String fileName, String encoding) {
        InputStream inputStream = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            if (inputStream == null) {
                throw new IllegalArgumentException("Properties file not found in classpath: " + fileName);
            }
            this.properties = new Properties();
            this.properties.load(new InputStreamReader(inputStream, encoding));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Prop(File file) {
        this(file, "UTF-8");
    }

    public Prop(File file, String encoding) {
        if (file == null) {
            throw new IllegalArgumentException("File can not be null.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("File not found : " + file.getName());
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            this.properties = new Properties();
            this.properties.load(new InputStreamReader((InputStream)inputStream, encoding));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key);
        return value != null ? value : defaultValue;
    }

    public Integer getInt(String key) {
        String value = this.get(key);
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    public Integer getInt(String key, Integer defaultValue) {
        String value = this.get(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public Long getLong(String key) {
        String value = this.get(key);
        return value != null ? Long.valueOf(Long.parseLong(value)) : null;
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.get(key);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    public Boolean getBoolean(String key) {
        String value = this.get(key);
        return value != null ? Boolean.valueOf(Boolean.parseBoolean(value)) : null;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.get(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Properties getProperties() {
        return this.properties;
    }
}

