/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.stats.distributions;

import com.github.signaflo.math.stats.distributions.Distribution;
import smile.math.Random;

public final class Uniform
implements Distribution {
    private final double a;
    private final double b;
    private final Random random = new Random();

    public Uniform(double a, double b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public double rand() {
        return this.random.nextDouble(this.a, this.b);
    }

    @Override
    public double quantile(double prob) {
        if (prob < 0.0 || prob > 1.0) {
            throw new IllegalArgumentException("The probability must be between 0 and 1 (inclusive).");
        }
        return prob * (this.b - this.a) + this.a;
    }

    public String toString() {
        return "Uniform(" + Double.toString(this.a) + ", " + Double.toString(this.b) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Uniform)) {
            return false;
        }
        Uniform other = (Uniform)o;
        if (Double.compare(this.a, other.a) != 0) {
            return false;
        }
        return Double.compare(this.b, other.b) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $a = Double.doubleToLongBits(this.a);
        result = result * 59 + (int)($a >>> 32 ^ $a);
        long $b = Double.doubleToLongBits(this.b);
        result = result * 59 + (int)($b >>> 32 ^ $b);
        return result;
    }
}

