/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.polynomial.interpolation;

import com.github.signaflo.math.function.CubicFunction;
import com.github.signaflo.math.function.QuadraticFunction;
import java.util.Arrays;

public final class NewtonPolynomial {
    private final double[] point;
    private final double[] value;
    private final double[] coefficients;

    public NewtonPolynomial(double[] point, double[] value) {
        if (point.length != value.length) {
            throw new IllegalArgumentException("There must be one function value for each point, but there were " + point.length + " points and " + value.length + " values.");
        }
        if (point.length == 0) {
            throw new IllegalArgumentException("A divided difference requires at least one point, but no points were given.");
        }
        this.point = (double[])point.clone();
        this.value = (double[])value.clone();
        this.coefficients = new double[value.length];
        for (int i = 0; i < point.length; ++i) {
            this.coefficients[i] = this.getDividedDifference(0, i);
        }
    }

    double getCoefficient(int i) {
        return this.coefficients[i];
    }

    private double getDividedDifference(int start, int end) {
        int k = end - start;
        if (k < 0) {
            throw new IllegalArgumentException("start must be less than end, but start was " + start + " and end was " + end);
        }
        if (k == 0) {
            return this.value[end];
        }
        if (k == 1) {
            return (this.value[end] - this.value[start]) / (this.point[end] - this.point[start]);
        }
        return (this.getDividedDifference(start + 1, end) - this.getDividedDifference(start, end - 1)) / (this.point[end] - this.point[start]);
    }

    public double evaluateAt(double x) {
        double product = 1.0;
        double result = this.coefficients[0];
        for (int i = 1; i < this.coefficients.length; ++i) {
            result += this.coefficients[i] * (product *= x - this.point[i - 1]);
        }
        return result;
    }

    public QuadraticFunction toQuadratic() throws IllegalStateException {
        if (this.coefficients.length < 3) {
            throw new IllegalStateException("The function is of degree " + (this.coefficients.length - 1) + " and thus not quadratic.");
        }
        double a = this.coefficients[2];
        double b = this.coefficients[1] - this.coefficients[2] * (this.point[0] + this.point[1]);
        double c = this.coefficients[0] - this.coefficients[1] * this.point[0] + this.coefficients[2] * this.point[0] * this.point[1];
        return new QuadraticFunction(a, b, c);
    }

    public CubicFunction toCubic() throws IllegalStateException {
        if (this.coefficients.length < 4) {
            throw new IllegalStateException("The function is of degree " + (this.coefficients.length - 1) + " and thus not cubic.");
        }
        double a = this.coefficients[3];
        double b = this.coefficients[2] - this.coefficients[3] * (this.point[0] + this.point[1] + this.point[2]);
        double c = this.coefficients[1] - this.coefficients[2] * (this.point[0] + this.point[1]) + this.coefficients[3] * (this.point[0] * this.point[1] + this.point[0] * this.point[2] + this.point[1] * this.point[2]);
        double d = this.coefficients[0] - this.coefficients[1] * this.point[0] + this.coefficients[2] * this.point[0] * this.point[1] - this.coefficients[3] * this.point[0] * this.point[1] * this.point[2];
        return new CubicFunction(a, b, c, d);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewtonPolynomial that = (NewtonPolynomial)o;
        return Arrays.equals(this.coefficients, that.coefficients);
    }

    public int hashCode() {
        return Arrays.hashCode(this.coefficients);
    }
}

