/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.polynomial.interpolation;

public final class LinearInterpolation {
    private final double a0;
    private final double a1;

    public LinearInterpolation(double x0, double x1, double f0, double f1) {
        if (x0 == x1) {
            throw new IllegalArgumentException("x0 and x1 must be distinct points, but both were equal to: " + x1);
        }
        this.a1 = (f1 - f0) / (x1 - x0);
        this.a0 = f1 - this.a1 * x1;
    }

    public double a0() {
        return this.a0;
    }

    public double a1() {
        return this.a1;
    }
}

