/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.optim;

import com.github.signaflo.math.function.AbstractMultivariateFunction;
import com.github.signaflo.math.linear.doubles.Matrix;
import com.github.signaflo.math.linear.doubles.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BFGS {
    private static final Logger logger = LoggerFactory.getLogger(BFGS.class);
    private static final double C1 = 1.0E-4;
    private static final double STEP_REDUCTION_FACTOR = 0.2;
    private final Matrix identity;
    private Vector iterate;
    private double functionValue;
    private double rho;
    private Vector s;
    private Vector y;
    private Matrix H;

    public BFGS(AbstractMultivariateFunction f, Vector startingPoint, double gradientTolerance, double functionChangeTolerance) {
        this(f, startingPoint, gradientTolerance, functionChangeTolerance, Matrix.identity(startingPoint.size()));
    }

    public BFGS(AbstractMultivariateFunction f, Vector startingPoint, double gradientNormTolerance, double relativeChangeTolerance, Matrix initialHessian) {
        this.identity = Matrix.identity(startingPoint.size());
        this.H = initialHessian;
        this.iterate = startingPoint;
        int k = 0;
        this.functionValue = f.at(startingPoint);
        Vector gradient = f.gradientAt(startingPoint, this.functionValue);
        int maxIterations = 100;
        if (gradient.size() > 0) {
            double gradientNorm = gradient.norm();
            boolean stop = gradientNorm < gradientNormTolerance || !Double.isFinite(gradientNorm);
            int iterationsSinceIdentityReset = 0;
            while (!stop) {
                double relativeChange;
                double relativeChangeDenominator;
                if (iterationsSinceIdentityReset > 2 * this.iterate.size()) {
                    this.H = this.identity;
                    iterationsSinceIdentityReset = 0;
                }
                ++iterationsSinceIdentityReset;
                Vector searchDirection = this.H.times(gradient).scaledBy(-1.0);
                double slopeAt0 = searchDirection.dotProduct(gradient);
                if (slopeAt0 > 0.0) {
                    this.H = this.identity;
                    searchDirection = this.H.times(gradient).scaledBy(-1.0);
                    slopeAt0 = searchDirection.dotProduct(gradient);
                }
                double stepSize = 1.0;
                this.s = searchDirection.scaledBy(stepSize);
                Vector nextIterate = this.iterate.plus(this.s);
                double priorFunctionValue = this.functionValue;
                this.functionValue = f.at(nextIterate);
                int maxStepReductions = 25;
                int stepReductions = 0;
                while (!(Double.isFinite(this.functionValue) && this.functionValue < priorFunctionValue + 1.0E-4 * stepSize * slopeAt0 || stop)) {
                    relativeChangeDenominator = Math.max(Math.abs(priorFunctionValue), Math.abs(nextIterate.norm()));
                    relativeChange = Math.abs((priorFunctionValue - this.functionValue) / relativeChangeDenominator);
                    if (relativeChange <= relativeChangeTolerance) {
                        stop = true;
                        continue;
                    }
                    if (stepReductions > 25) {
                        logger.warn("Maximum step reductions, 25", (Object)" exceeded.Stopping BFGS algorithm.");
                        stop = true;
                        continue;
                    }
                    ++stepReductions;
                    this.s = searchDirection.scaledBy(stepSize *= 0.2);
                    nextIterate = this.iterate.plus(this.s);
                    this.functionValue = f.at(nextIterate);
                }
                Vector nextGradient = f.gradientAt(nextIterate, this.functionValue);
                if (!stop && ((relativeChange = Math.abs((priorFunctionValue - this.functionValue) / (relativeChangeDenominator = Math.max(Math.abs(priorFunctionValue), Math.abs(nextIterate.norm()))))) <= relativeChangeTolerance || nextGradient.norm() < gradientNormTolerance)) {
                    stop = true;
                }
                this.y = nextGradient.minus(gradient);
                double yDotS = this.y.dotProduct(this.s);
                if (yDotS > 0.0) {
                    this.rho = 1.0 / yDotS;
                    this.H = this.updateHessian();
                } else if (!stop) {
                    this.H = this.identity;
                    iterationsSinceIdentityReset = 0;
                }
                this.iterate = nextIterate;
                gradient = nextGradient;
                if (++k <= maxIterations) continue;
                stop = true;
            }
        }
    }

    private Matrix updateHessian() {
        Matrix a = this.identity.minus(this.s.outerProduct(this.y).scaledBy(this.rho));
        Matrix b = this.identity.minus(this.y.outerProduct(this.s).scaledBy(this.rho));
        Matrix c = this.s.outerProduct(this.s).scaledBy(this.rho);
        return a.times(this.H).times(b).plus(c);
    }

    public double functionValue() {
        return this.functionValue;
    }

    public Vector parameters() {
        return this.iterate;
    }

    public Matrix inverseHessian() {
        return this.H;
    }
}

