/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.linear.doubles;

import com.github.signaflo.math.linear.doubles.GenericVector;
import com.github.signaflo.math.linear.doubles.Matrix;
import com.github.signaflo.math.operations.DoubleFunctions;

public interface Vector {
    public static Vector ones(int n) {
        return new GenericVector(DoubleFunctions.fill(n, 1.0));
    }

    public static Vector zeros(int n) {
        return new GenericVector(DoubleFunctions.fill(n, 0.0));
    }

    public static Vector from(double ... elements) {
        return new GenericVector(elements);
    }

    public double[] elements();

    public double at(int var1);

    public int size();

    public Vector plus(Vector var1);

    public Vector minus(Vector var1);

    public Vector minus(double var1);

    public Vector scaledBy(double var1);

    public double dotProduct(Vector var1);

    public Matrix outerProduct(Vector var1);

    public double norm();

    public double sum();

    public double sumOfSquares();

    public Vector push(double var1);
}

