/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.linear.doubles;

import com.github.signaflo.math.linear.doubles.Matrix;
import com.github.signaflo.math.linear.doubles.Vector;
import com.github.signaflo.math.operations.Validate;

public final class QuadraticForm {
    private final Vector x;
    private final Matrix A;

    public QuadraticForm(Vector x, Matrix A) {
        QuadraticForm.validateArguments(x, A);
        this.x = x;
        this.A = A;
    }

    public static double multiply(Vector x, Matrix A) {
        QuadraticForm.validateArguments(x, A);
        int n = x.size();
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                result += x.at(i) * x.at(j) * A.get(i, j);
            }
        }
        return result;
    }

    private static void validateArguments(Vector x, Matrix A) {
        Validate.argumentsNotNull(x.getClass(), x);
        Validate.argumentsNotNull(A.getClass(), A);
        if (!A.isSquare()) {
            throw new IllegalArgumentException("The matrix must be square.");
        }
        if (x.size() != A.nrow()) {
            throw new IllegalArgumentException("The number of matrix columns must be the same as the size of the vector.");
        }
    }

    public double multiply() {
        return QuadraticForm.multiply(this.x, this.A);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuadraticForm that = (QuadraticForm)o;
        if (!this.x.equals(that.x)) {
            return false;
        }
        return this.A.equals(that.A);
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = 31 * result + this.A.hashCode();
        return result;
    }

    public String toString() {
        return "QuadraticForm(x=" + this.x + ", A=" + this.A + ")";
    }
}

