/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.linear.doubles;

import com.github.signaflo.math.linear.doubles.GenericVector;
import com.github.signaflo.math.linear.doubles.Matrix;
import com.github.signaflo.math.linear.doubles.MatrixBuilder;
import com.github.signaflo.math.linear.doubles.Vector;
import java.util.Arrays;

final class MatrixOneD
implements Matrix {
    private final int nrow;
    private final int ncol;
    private final double[] data;
    private final Matrix.Layout layout;

    MatrixOneD(int nrow, int ncol, double ... data) {
        if (nrow * ncol != data.length) {
            throw new IllegalArgumentException("The dimensions do not match the amount of data provided. There were " + data.length + " data points provided but the number of columns and columns were " + nrow + " and " + ncol + " respectively.");
        }
        this.nrow = nrow;
        this.ncol = ncol;
        this.data = (double[])data.clone();
        this.layout = Matrix.Layout.BY_ROW;
    }

    MatrixOneD(int nrow, int ncol, double value) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.data = new double[nrow * ncol];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = value;
        }
        this.layout = Matrix.Layout.BY_ROW;
    }

    MatrixOneD(Matrix.Layout layout, double[] ... matrixData) {
        this.layout = layout;
        if (matrixData.length == 0) {
            this.ncol = 0;
            this.nrow = 0;
            this.data = new double[0];
        } else if (layout == Matrix.Layout.BY_COLUMN) {
            this.ncol = matrixData.length;
            this.nrow = matrixData[0].length;
            this.data = new double[this.ncol * this.nrow];
            for (int i = 0; i < this.nrow; ++i) {
                for (int j = 0; j < this.ncol; ++j) {
                    this.data[i * this.ncol + j] = matrixData[j][i];
                }
            }
        } else {
            this.nrow = matrixData.length;
            this.ncol = matrixData[0].length;
            this.data = new double[this.nrow * this.ncol];
            for (int i = 0; i < this.nrow; ++i) {
                System.arraycopy(matrixData[i], 0, this.data, i * this.ncol, this.ncol);
            }
        }
    }

    @Override
    public double get(int i, int j) {
        return this.data[i * this.ncol + j];
    }

    @Override
    public int nrow() {
        return this.nrow;
    }

    @Override
    public int ncol() {
        return this.ncol;
    }

    @Override
    public MatrixOneD plus(Matrix other) {
        if (this.nrow != other.nrow() || this.ncol != other.ncol()) {
            throw new IllegalArgumentException("The dimensions of this matrix must equal the dimensions of the other matrix. This matrix has dimension (" + this.nrow + ", " + this.ncol + ") and the other matrix has dimension (" + other.nrow() + ", " + other.ncol() + ")");
        }
        double[] sum = new double[this.nrow * this.ncol];
        double[] otherData = other.data();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                sum[i * this.ncol + j] = this.data[i * this.ncol + j] + otherData[i * this.ncol + j];
            }
        }
        return new MatrixOneD(this.nrow, this.ncol, sum);
    }

    @Override
    public MatrixOneD times(Matrix other) {
        if (this.ncol != other.nrow()) {
            throw new IllegalArgumentException("The columns of this matrix must equal the columns of the other matrix. This matrix has " + this.ncol + " columns and the other matrix has " + other.nrow() + " columns.");
        }
        double[] product = new double[this.nrow * other.ncol()];
        double[] otherData = other.data();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < other.ncol(); ++j) {
                for (int k = 0; k < this.ncol; ++k) {
                    int n = i * this.nrow + j;
                    product[n] = product[n] + this.data[i * this.ncol + k] * otherData[j + k * other.ncol()];
                }
            }
        }
        return new MatrixOneD(this.nrow, other.ncol(), product);
    }

    @Override
    public Vector times(Vector vector) {
        double[] elements = vector.elements();
        if (this.ncol != elements.length) {
            throw new IllegalArgumentException("The columns of this matrix must equal the columns of the vector. This matrix has " + this.ncol + " columns and the vector has " + elements.length + " columns.");
        }
        double[] product = new double[this.nrow];
        for (int i = 0; i < this.nrow; ++i) {
            for (int k = 0; k < this.ncol; ++k) {
                int n = i;
                product[n] = product[n] + this.data[i * this.ncol + k] * elements[k];
            }
        }
        return new GenericVector(product);
    }

    @Override
    public MatrixOneD scaledBy(double c) {
        double[] scaled = new double[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            scaled[i] = this.data[i] * c;
        }
        return new MatrixOneD(this.nrow, this.ncol, scaled);
    }

    @Override
    public MatrixOneD minus(Matrix other) {
        if (this.nrow != other.nrow() || this.ncol != other.ncol()) {
            throw new IllegalArgumentException("The dimensions of this matrix must equal the dimensions of the other matrix. This matrix has dimension (" + this.nrow + ", " + this.ncol + ") and the other matrix has dimension (" + other.nrow() + ", " + other.ncol() + ")");
        }
        double[] minus = new double[this.nrow * this.ncol];
        double[] otherData = other.data();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                minus[i * this.ncol + j] = this.data[i * this.ncol + j] - otherData[i * this.ncol + j];
            }
        }
        return new MatrixOneD(this.nrow, this.ncol, minus);
    }

    @Override
    public boolean isSquare() {
        return this.nrow == this.ncol;
    }

    @Override
    public Matrix transpose() {
        double[] transposedData = new double[this.data.length];
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                transposedData[i + j * this.nrow] = this.data[j + i * this.ncol];
            }
        }
        return new MatrixOneD(this.ncol, this.nrow, transposedData);
    }

    @Override
    public Vector getRow(int i) {
        double[] row = new double[this.ncol];
        int offset = this.ncol * i;
        System.arraycopy(this.data, offset, row, 0, row.length);
        return Vector.from(row);
    }

    @Override
    public Vector getColumn(int j) {
        double[] col = new double[this.nrow];
        for (int i = 0; i < col.length; ++i) {
            col[i] = this.data[i * this.ncol + j];
        }
        return Vector.from(col);
    }

    @Override
    public Matrix pushColumn(Vector newData) {
        if (newData.size() != this.nrow) {
            throw new IllegalArgumentException("The number of elements of the new column must match the number of columns of the matrix.");
        }
        double[][] thisData = this.data2D(Matrix.Layout.BY_COLUMN);
        double[][] newMatrix = new double[this.ncol + 1][];
        newMatrix[0] = newData.elements();
        for (int i = 1; i < newMatrix.length; ++i) {
            newMatrix[i] = (double[])thisData[i - 1].clone();
        }
        return new MatrixOneD(Matrix.Layout.BY_COLUMN, newMatrix);
    }

    @Override
    public Matrix pushRow(Vector newData) {
        if (newData.size() != this.ncol) {
            throw new IllegalArgumentException("The number of elements of the new row must match the number of columns of the matrix.");
        }
        double[] newMatrix = new double[newData.size() + this.data.length];
        System.arraycopy(newData.elements(), 0, newMatrix, 0, newData.size());
        System.arraycopy(this.data, 0, newMatrix, newData.size(), this.data.length);
        return new MatrixOneD(this.nrow + 1, this.ncol, newMatrix);
    }

    @Override
    public double[] diagonal() {
        double[] diag = new double[Math.min(this.nrow, this.ncol)];
        for (int i = 0; i < diag.length; ++i) {
            diag[i] = this.data[this.ncol * i + i];
        }
        return diag;
    }

    @Override
    public double[] data() {
        return (double[])this.data.clone();
    }

    @Override
    public double[][] data2D(Matrix.Layout layout) {
        if (layout == Matrix.Layout.BY_ROW) {
            return this.data2DRowMajor();
        }
        return this.data2DColumnMajor();
    }

    @Override
    public double[][] data2D() {
        if (this.layout == Matrix.Layout.BY_ROW) {
            return this.data2DRowMajor();
        }
        return this.data2DColumnMajor();
    }

    private double[][] data2DRowMajor() {
        double[][] twoD = new double[this.nrow][this.ncol];
        for (int i = 0; i < this.nrow; ++i) {
            System.arraycopy(this.data, i * this.ncol, twoD[i], 0, this.ncol);
        }
        return twoD;
    }

    private double[][] data2DColumnMajor() {
        double[][] twoD = new double[this.ncol][this.nrow];
        for (int i = 0; i < this.ncol; ++i) {
            for (int j = 0; j < this.nrow; ++j) {
                twoD[i][j] = this.data[i + j * this.ncol];
            }
        }
        return twoD;
    }

    public Matrix getSymmetricPart() {
        return this.plus(this.transpose()).scaledBy(0.5);
    }

    public String toString() {
        String newLine = System.lineSeparator();
        StringBuilder representation = new StringBuilder(newLine);
        double[][] twoD = this.data2D(Matrix.Layout.BY_ROW);
        for (int i = 0; i < this.nrow; ++i) {
            representation.append(Arrays.toString(twoD[i])).append(newLine);
        }
        return representation.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatrixOneD matrix = (MatrixOneD)o;
        return this.nrow == matrix.nrow && this.ncol == matrix.ncol && Arrays.equals(this.data, matrix.data);
    }

    public int hashCode() {
        int result = this.nrow;
        result = 31 * result + this.ncol;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static final class ZeroBuilder
    implements MatrixBuilder {
        final int m;
        final int n;
        final double[] data;

        ZeroBuilder(int m, int n) {
            this.m = m;
            this.n = n;
            this.data = new double[m * n];
        }

        @Override
        public ZeroBuilder set(int i, int j, double value) {
            ZeroBuilder.validateRow(i, this.m);
            ZeroBuilder.validateColumn(j, this.n);
            this.data[i * this.n + j] = value;
            return this;
        }

        @Override
        public ZeroBuilder setRow(int i, Vector row) {
            ZeroBuilder.validateRow(i, this.m);
            ZeroBuilder.validateSize(this.n, row);
            System.arraycopy(row.elements(), 0, this.data, i * this.n, this.n);
            return this;
        }

        @Override
        public ZeroBuilder setColumn(int j, Vector column) {
            ZeroBuilder.validateColumn(j, this.n);
            ZeroBuilder.validateSize(this.m, column);
            for (int i = 0; i < this.m; ++i) {
                this.data[i * this.n + j] = column.at(i);
            }
            return this;
        }

        @Override
        public Matrix build() {
            return new MatrixOneD(this.m, this.n, this.data);
        }

        static void validateRow(int i, int m) {
            if (i >= m) {
                throw new IllegalArgumentException("The row index must be less than the number of rows, but the index, " + i + ", is greater than or equal to " + m);
            }
            if (i < 0) {
                throw new IllegalArgumentException("The row index must be greater than or equal to zero, but was " + i);
            }
        }

        static void validateColumn(int i, int n) {
            if (i >= n) {
                throw new IllegalArgumentException("The column index must be less than the number of columns, but the index, " + i + ", is greater than or equal to " + n);
            }
            if (i < 0) {
                throw new IllegalArgumentException("The column index must be greater than or equal to zero, but was " + i);
            }
        }

        static void validateSize(int n, Vector vector) {
            if (vector.size() != n) {
                throw new IllegalArgumentException("The vector must have " + n + " elements, but had " + vector.size());
            }
        }
    }

    static final class IdentityBuilder
    implements MatrixBuilder {
        final int n;
        final double[] data;

        IdentityBuilder(int n) {
            this.n = n;
            this.data = new double[n * n];
            for (int i = 0; i < n; ++i) {
                this.data[i * n + i] = 1.0;
            }
        }

        @Override
        public IdentityBuilder set(int i, int j, double value) {
            ZeroBuilder.validateRow(i, this.n);
            ZeroBuilder.validateColumn(j, this.n);
            this.data[i * this.n + j] = value;
            return this;
        }

        @Override
        public Matrix build() {
            return new MatrixOneD(this.n, this.n, this.data);
        }

        @Override
        public IdentityBuilder setRow(int i, Vector row) {
            ZeroBuilder.validateRow(i, this.n);
            ZeroBuilder.validateSize(this.n, row);
            System.arraycopy(row.elements(), 0, this.data, i * this.n, this.n);
            return this;
        }

        @Override
        public IdentityBuilder setColumn(int j, Vector column) {
            ZeroBuilder.validateColumn(j, this.n);
            ZeroBuilder.validateSize(this.n, column);
            for (int i = 0; i < this.n; ++i) {
                this.data[i * this.n + j] = column.at(i);
            }
            return this;
        }
    }
}

