/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.linear.doubles;

import com.github.signaflo.math.linear.doubles.MatrixBuilder;
import com.github.signaflo.math.linear.doubles.MatrixOneD;
import com.github.signaflo.math.linear.doubles.Vector;

public interface Matrix {
    public static Matrix create(int nrow, int ncol, double ... data) {
        return new MatrixOneD(nrow, ncol, data);
    }

    public static Matrix fill(int nrow, int ncol, double value) {
        return new MatrixOneD(nrow, ncol, value);
    }

    public static Matrix create(double[] ... matrixData) {
        return new MatrixOneD(Layout.BY_ROW, matrixData);
    }

    public static Matrix create(Layout layout, double[] ... matrixData) {
        return new MatrixOneD(layout, matrixData);
    }

    public static Matrix identity(int n) {
        double[] data = new double[n * n];
        for (int i = 0; i < n; ++i) {
            data[i * n + i] = 1.0;
        }
        return new MatrixOneD(n, n, data);
    }

    public double get(int var1, int var2);

    public int nrow();

    public int ncol();

    public Matrix plus(Matrix var1);

    public Matrix times(Matrix var1);

    public Vector times(Vector var1);

    public Matrix scaledBy(double var1);

    public Matrix minus(Matrix var1);

    public boolean isSquare();

    public Matrix transpose();

    public Vector getRow(int var1);

    public Vector getColumn(int var1);

    public Matrix pushRow(Vector var1);

    public Matrix pushColumn(Vector var1);

    public double[] diagonal();

    public double[] data();

    public double[][] data2D(Layout var1);

    public double[][] data2D();

    public static MatrixBuilder identityBuilder(int n) {
        return new MatrixOneD.IdentityBuilder(n);
    }

    public static MatrixBuilder builder(int m, int n) {
        return new MatrixOneD.ZeroBuilder(m, n);
    }

    public static enum Layout {
        BY_ROW,
        BY_COLUMN;

    }
}

