/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.linear.doubles;

import com.github.signaflo.math.linear.doubles.Matrix2;
import com.github.signaflo.math.linear.doubles.Vector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

class ColumnMatrix
implements Matrix2 {
    private final List<Vector> columnVectors;
    private final int nrow;
    private final int ncol;

    ColumnMatrix(@NonNull List<Vector> columnVectors) {
        if (columnVectors == null) {
            throw new NullPointerException("columnVectors");
        }
        this.columnVectors = new ArrayList<Vector>(columnVectors);
        this.ncol = this.columnVectors.size();
        this.nrow = this.ncol > 0 ? columnVectors.get(0).size() : 0;
    }

    ColumnMatrix(int nrow, int ncol) {
        this.columnVectors = new ArrayList<Vector>(nrow);
        this.nrow = nrow;
        this.ncol = ncol;
    }

    ColumnMatrix(int nrow, int ncol, @NonNull List<Vector> vectors) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (ncol != vectors.size()) {
            throw new IllegalArgumentException("The number of columns must equal the number of vectors.");
        }
        this.nrow = nrow;
        this.ncol = ncol;
        this.columnVectors = new ArrayList<Vector>(vectors);
    }

    @Override
    public List<Vector> getRows() {
        ArrayList<Vector> rows = new ArrayList<Vector>(this.ncol);
        if (this.columnVectors.isEmpty()) {
            return rows;
        }
        double[] rowElements = new double[this.ncol];
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                rowElements[j] = this.columnVectors.get(j).at(i);
            }
            rows.add(Vector.from(rowElements));
        }
        return rows;
    }

    @Override
    public List<Vector> getColumns() {
        return new ArrayList<Vector>(this.columnVectors);
    }

    @Override
    public int nrow() {
        return this.nrow;
    }

    @Override
    public int ncol() {
        return this.ncol;
    }

    @Override
    public Matrix2 times(Matrix2 other) {
        if (this.ncol != other.nrow()) {
            throw new IllegalArgumentException("The number of columns of this matrix must equal the number of rows of the other matrix.");
        }
        if (this.nrow == 0 || other.ncol() == 0) {
            return new ColumnMatrix(this.nrow, other.ncol());
        }
        if (this.ncol == 0) {
            return this.filledMatrixFromEmptyMatrices(this.nrow, other.ncol());
        }
        List<Vector> otherColumns = other.getColumns();
        ArrayList<Vector> product = new ArrayList<Vector>(this.ncol);
        for (int i = 0; i < otherColumns.size(); ++i) {
            product.add(this.times(otherColumns.get(i)));
        }
        return new ColumnMatrix(this.nrow, other.ncol(), product);
    }

    private Matrix2 filledMatrixFromEmptyMatrices(int nrow, int ncol) {
        ArrayList<Vector> columns = new ArrayList<Vector>(ncol);
        for (int i = 0; i < ncol; ++i) {
            columns.add(Vector.zeros(nrow));
        }
        return new ColumnMatrix(columns);
    }

    @Override
    public Vector times(Vector vector) {
        if (vector.size() != this.ncol) {
            throw new IllegalArgumentException("The number of elements of the given vector must equal the number of columns of this matrix.");
        }
        Vector product = Vector.zeros(this.nrow);
        for (int i = 0; i < this.ncol; ++i) {
            product = product.plus(this.columnVectors.get(i).scaledBy(vector.at(i)));
        }
        return product;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Arrays.equals(o.getClass().getInterfaces(), this.getClass().getInterfaces())) {
            return false;
        }
        Matrix2 that = (Matrix2)o;
        if (this.nrow != that.nrow()) {
            return false;
        }
        if (this.ncol != that.ncol()) {
            return false;
        }
        return this.columnVectors.equals(that.getColumns());
    }

    public int hashCode() {
        int result = this.columnVectors.hashCode();
        result = 31 * result + this.nrow;
        result = 31 * result + this.ncol;
        return result;
    }

    public String toString() {
        return "ColumnMatrix(columnVectors=" + this.columnVectors + ", nrow=" + this.nrow + ", ncol=" + this.ncol + ")";
    }
}

