/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.linear;

import com.github.signaflo.math.Real;
import com.github.signaflo.math.linear.FieldMatrix;
import com.github.signaflo.math.linear.Vectors;
import java.util.ArrayList;

class Matrices {
    private Matrices() {
    }

    static FieldMatrix<Real> matrixFrom(double[] ... matrix) {
        ArrayList realVectors = new ArrayList(matrix.length);
        for (double[] column : matrix) {
            realVectors.add(Vectors.vectorFrom(column));
        }
        return new FieldMatrix<Real>(realVectors);
    }

    static FieldMatrix<Real> matrixFrom(int nrows, int ncols, double ... data) {
        return Matrices.matrixFrom(MatrixOrder.ROW_MAJOR, nrows, ncols, data);
    }

    static FieldMatrix<Real> matrixFrom(MatrixOrder order, int nrows, int ncols, double ... data) {
        switch (order) {
            case ROW_MAJOR: {
                return Matrices.rowMajorMatrix(nrows, ncols, data);
            }
        }
        return Matrices.columnMajorMatrix(nrows, ncols, data);
    }

    private static FieldMatrix<Real> rowMajorMatrix(int nrows, int ncols, double ... data) {
        ArrayList realVectors = new ArrayList(ncols);
        for (int i = 0; i < ncols; ++i) {
            double[] column = new double[nrows];
            for (int j = 0; j < nrows; ++j) {
                column[j] = data[i + j * ncols];
            }
            realVectors.add(Vectors.vectorFrom(column));
        }
        return new FieldMatrix<Real>(realVectors);
    }

    private static FieldMatrix<Real> columnMajorMatrix(int nrows, int ncols, double ... data) {
        ArrayList realVectors = new ArrayList(ncols);
        for (int i = 0; i < ncols; ++i) {
            double[] column = new double[nrows];
            for (int j = 0; j < nrows; ++j) {
                column[j] = data[i * nrows + j];
            }
            realVectors.add(Vectors.vectorFrom(column));
        }
        return new FieldMatrix<Real>(realVectors);
    }

    static enum MatrixOrder {
        ROW_MAJOR,
        COLUMN_MAJOR;

    }
}

