/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.linear;

import com.github.signaflo.math.FieldElement;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class FieldVector<T extends FieldElement<T>> {
    private final List<T> elements;

    FieldVector(List<T> elements) {
        this.elements = ImmutableList.copyOf(elements);
    }

    @SafeVarargs
    FieldVector(T ... elements) {
        this.elements = ImmutableList.copyOf(Arrays.asList((Object[])elements.clone()));
    }

    List<T> elements() {
        return this.elements;
    }

    T at(int i) {
        return (T)((FieldElement)this.elements.get(i));
    }

    int size() {
        return this.elements.size();
    }

    FieldVector<T> plus(FieldVector<T> other) {
        ArrayList<T> summed = new ArrayList<T>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            summed.add(((FieldElement)this.elements.get(i)).plus(other.elements.get(i)));
        }
        return new FieldVector(summed);
    }

    FieldVector<T> minus(FieldVector<T> other) {
        ArrayList<T> differenced = new ArrayList<T>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            differenced.add(((FieldElement)this.elements.get(i)).minus(other.elements.get(i)));
        }
        return new FieldVector(differenced);
    }

    FieldVector<T> scaledBy(T alpha) {
        ArrayList<T> scaled = new ArrayList<T>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            scaled.add(((FieldElement)this.elements.get(i)).times(alpha));
        }
        return new FieldVector(scaled);
    }

    FieldVector<T> axpy(FieldVector<T> other, T alpha) {
        ArrayList<T> result = new ArrayList<T>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.add(((FieldElement)((FieldElement)this.elements.get(i)).times(alpha)).plus(other.elements.get(i)));
        }
        return new FieldVector(result);
    }

    T dotProduct(FieldVector<T> other) {
        if (this.size() > 0) {
            FieldElement product = (FieldElement)((FieldElement)this.elements.get(0)).times(((FieldElement)other.elements.get(0)).conjugate());
            for (int t = 1; t < this.elements.size(); ++t) {
                product = (FieldElement)product.plus(((FieldElement)this.elements.get(t)).times(((FieldElement)other.elements.get(t)).conjugate()));
            }
            return (T)product;
        }
        throw new IllegalStateException("The dot product is undefined for zero length vectors.");
    }

    double norm() {
        return Math.sqrt(this.sumOfSquares());
    }

    private double sumOfSquares() {
        double sum = 0.0;
        if (this.size() > 0) {
            sum = Math.pow(((FieldElement)this.elements.get(0)).abs(), 2.0);
            for (int i = 1; i < this.elements.size(); ++i) {
                sum += Math.pow(((FieldElement)this.elements.get(i)).abs(), 2.0);
            }
        }
        return sum;
    }

    public String toString() {
        return "elements: " + this.elements;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldVector other = (FieldVector)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }
}

