/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.function;

import com.github.signaflo.math.Complex;
import com.github.signaflo.math.Real;
import com.github.signaflo.math.function.AbstractFunction;
import com.github.signaflo.math.function.QuadraticFunction;

public final class CubicFunction
extends AbstractFunction {
    private final Real a;
    private final Real b;
    private final Real c;
    private final Real d;
    private final QuadraticFunction derivative;

    public CubicFunction(Real a, Real b, Real c, Real d) {
        if (a.asDouble() == 0.0) {
            throw new IllegalArgumentException("The first coefficient, a, cannot be zero.");
        }
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.derivative = new QuadraticFunction(a.times(3.0), b.times(2.0), c);
    }

    public CubicFunction(double a, double b, double c, double d) {
        if (a == 0.0) {
            throw new IllegalArgumentException("The first coefficient, a, cannot be zero.");
        }
        this.a = Real.from(a);
        this.b = Real.from(b);
        this.c = Real.from(c);
        this.d = Real.from(d);
        this.derivative = new QuadraticFunction(a * 3.0, b * 2.0, c);
    }

    public Real a() {
        return this.a;
    }

    public Real b() {
        return this.b;
    }

    public Real c() {
        return this.c;
    }

    public Real d() {
        return this.d;
    }

    public Real at(Real point) {
        return Real.from(this.at(point.asDouble()));
    }

    @Override
    public double at(double x) {
        return x * x * x * this.a.asDouble() + x * x * this.b.asDouble() + x * this.c.asDouble() + this.d.asDouble();
    }

    @Override
    public double slopeAt(double x) {
        return 3.0 * x * x * this.a.asDouble() + 2.0 * x * this.b.asDouble() + this.c.asDouble();
    }

    public Real[] coefficients() {
        return new Real[]{this.a, this.b, this.c, this.d};
    }

    public double[] coefficientsDbl() {
        return new double[]{this.a.asDouble(), this.b.asDouble(), this.c.asDouble(), this.d.asDouble()};
    }

    final Real[] criticalPoints() {
        Complex[] zeros = this.derivative.zeros();
        if (zeros[0].minus(zeros[1]).abs() < Math.ulp(1.0)) {
            return new Real[]{Real.from(zeros[0].real())};
        }
        if (this.allReal(zeros)) {
            return this.toReal(zeros);
        }
        return new Real[0];
    }

    final Real localMinimum() {
        return this.at(this.localMinimumPoint());
    }

    final Real localMaximum() {
        return this.at(this.localMaximumPoint());
    }

    final Real localMinimumPoint() {
        if (!this.hasMinimum()) {
            throw new RuntimeException("This cubic function " + this.toString() + " has no local minimum.");
        }
        Real[] extremePoints = this.localExtremePoints();
        if (extremePoints[0].asDouble() * this.a.asDouble() > this.b.asDouble() / -3.0) {
            return extremePoints[0];
        }
        return extremePoints[1];
    }

    final Real localMaximumPoint() {
        if (!this.hasMaximum()) {
            throw new RuntimeException("This cubic function " + this.toString() + " has no local maximum.");
        }
        Real[] extremePoints = this.localExtremePoints();
        if (extremePoints[0].asDouble() * this.a.asDouble() < this.b.asDouble() / -3.0) {
            return extremePoints[0];
        }
        return extremePoints[1];
    }

    public Real[] localExtremePoints() {
        Real[] points = this.criticalPoints();
        if (points.length < 2) {
            return new Real[0];
        }
        return points;
    }

    public Real[] localExtrema() {
        Real[] x = this.localExtremePoints();
        return this.evaluate(x);
    }

    public boolean hasMinimum() {
        return this.computeDiscriminant() > 0.0;
    }

    public boolean hasMaximum() {
        return this.computeDiscriminant() > 0.0;
    }

    private boolean allReal(Complex[] numbers) {
        for (Complex number : numbers) {
            if (number.isReal()) continue;
            return false;
        }
        return numbers.length != 0;
    }

    private Real[] toReal(Complex[] numbers) {
        Real[] reals = new Real[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            reals[i] = Real.from(numbers[i].real());
        }
        return reals;
    }

    private double computeDiscriminant() {
        return this.b.asDouble() * this.b.asDouble() - 3.0 * this.a.asDouble() * this.c.asDouble();
    }

    private Real[] evaluate(Real[] points) {
        Real[] values = new Real[points.length];
        for (int i = 0; i < points.length; ++i) {
            double x = points[i].asDouble();
            values[i] = Real.from(this.a.asDouble() * x * x * x + this.b.asDouble() * x * x + this.c.asDouble() * x + this.d.asDouble());
        }
        return values;
    }

    public String toString() {
        return "f(x) = " + this.a.asDouble() + "x^3 + " + this.b.asDouble() + "x^2 + " + this.c.asDouble() + "x + " + this.d.asDouble();
    }
}

