/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.function;

import com.github.signaflo.math.function.Function;
import com.github.signaflo.math.function.NumericalDerivatives;

public abstract class AbstractFunction
implements Function {
    protected int functionEvaluations = 0;
    protected int slopeEvaluations = 0;

    public double slopeAt(double point) {
        ++this.slopeEvaluations;
        return NumericalDerivatives.centralDifferenceApproximation(this, point, 0.001);
    }

    public double slopeAt(double point, double functionValue) {
        ++this.slopeEvaluations;
        return NumericalDerivatives.forwardDifferenceApproximation(this, point, 1.0E-6, functionValue);
    }

    public int functionEvaluations() {
        return this.functionEvaluations;
    }

    public int slopeEvaluations() {
        return this.slopeEvaluations;
    }
}

