/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math;

import com.github.signaflo.math.Complex;
import com.github.signaflo.math.FieldElement;
import lombok.NonNull;

public final class Real
implements FieldElement<Real> {
    private final double value;

    public static Real from(double value) {
        return new Real(value);
    }

    public static Real zero() {
        return Real.from(0.0);
    }

    private Real(double value) {
        this.value = value;
    }

    @Override
    public Real plus(Real other) {
        return Real.from(this.value + other.value);
    }

    @Override
    public Complex plus(Complex complex) {
        return Complex.from(this).plus(complex);
    }

    @Override
    public Real minus(Real other) {
        return Real.from(this.value - other.value);
    }

    @Override
    public Complex minus(Complex complex) {
        return Complex.from(this).minus(complex);
    }

    @Override
    public Real times(Real other) {
        return Real.from(this.value * other.value);
    }

    @Override
    public Real sqrt() {
        if (this.value < 0.0) {
            throw new IllegalStateException("Attempt to take the square root of a negative number on a Real type.");
        }
        return Real.from(Math.sqrt(this.value));
    }

    @Override
    public Complex complexSqrt() {
        if (this.value < 0.0) {
            Complex c = new Complex(this.value);
            return c.complexSqrt();
        }
        return new Complex(Math.sqrt(this.value));
    }

    @Override
    public Real conjugate() {
        return this;
    }

    @Override
    public Real times(double other) {
        return Real.from(this.value * other);
    }

    public Real squared() {
        return Real.from(this.value * this.value);
    }

    public Real cubed() {
        return Real.from(this.value * this.value * this.value);
    }

    @Override
    public Real dividedBy(Real other) {
        return Real.from(this.value / other.value);
    }

    @Override
    public Real additiveInverse() {
        return Real.from(-this.value);
    }

    @Override
    public double abs() {
        return Math.abs(this.value);
    }

    public double asDouble() {
        return this.value;
    }

    public String toString() {
        return "Real: " + Double.toString(this.value);
    }

    @Override
    public int compareTo(@NonNull Real other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return Double.compare(this.value, other.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Real)) {
            return false;
        }
        Real other = (Real)o;
        return Double.compare(this.value, other.value) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.value);
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    public static final class Interval {
        private final Real lower;
        private final Real upper;

        Interval(Real lower, Real upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public Interval(double lower, double upper) {
            this.lower = Real.from(lower);
            this.upper = Real.from(upper);
        }

        public double lowerDbl() {
            return this.lower.asDouble();
        }

        public double upperDbl() {
            return this.upper.asDouble();
        }

        public Real lower() {
            return this.lower;
        }

        public Real upper() {
            return this.upper;
        }

        public boolean endpointsEqual() {
            return this.lowerDbl() == this.upperDbl();
        }

        public boolean endpointsEqual(double epsilon) {
            return Math.abs(this.lower.value - this.upper.value) < epsilon;
        }

        public boolean contains(double value) {
            if (this.lower.value < this.upper.value) {
                return value >= this.lower.value && value <= this.upper.value;
            }
            return value <= this.lower.value && value >= this.upper.value;
        }

        public boolean doesntContain(double value) {
            return !this.contains(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Interval interval = (Interval)o;
            if (!this.lower.equals(interval.lower)) {
                return false;
            }
            return this.upper.equals(interval.upper);
        }

        public int hashCode() {
            int result = this.lower.hashCode();
            result = 31 * result + this.upper.hashCode();
            return result;
        }

        public String toString() {
            return "(" + Double.toString(this.lower.asDouble()) + ", " + Double.toString(this.upper.asDouble()) + ")";
        }
    }
}

