/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.factory.BuildTemplateFactory;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.template.IDocBuildTemplate;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class AdocDocBuilder {
    private static final String API_EXTENSION = "Api.adoc";
    private static final String INDEX_DOC = "index.adoc";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        AdocDocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, false);
        config.setParamsDataToTree(false);
        config.setAdoc(true);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework());
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        if (config.isAllInOne()) {
            String docName = builderTemplate.allInOneDocName(config, INDEX_DOC, ".adoc");
            apiDocList = docBuildTemplate.handleApiGroup(apiDocList, config);
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "AllInOne.adoc", docName);
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "ApiDoc.adoc", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config, "ErrorCodeList.adoc", "ErrorCodeList.adoc");
            builderTemplate.buildDirectoryDataDoc(config, javaProjectBuilder, "Dictionary.btl", "Dictionary.adoc");
        }
    }

    public static void buildSingleApiDoc(ApiConfig config, String controllerName) {
        config.setAdoc(false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, new JavaProjectBuilder());
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, false);
        builderTemplate.buildSingleApi(configBuilder, controllerName, "ApiDoc.adoc", API_EXTENSION);
    }
}

