/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ForbidWildcardAsReturnTypeCheck
extends AbstractCheck {
    public static final String MSG_KEY = "forbid.wildcard.as.return.type";
    private static final int WILDCARD_EXTENDS_IDENT = 168;
    private static final int WILDCARD_SUPER_IDENT = 169;
    private static final String DEPRECATED = "Deprecated";
    private static final String FQ_DEPRECATED = "java.lang.Deprecated";
    private static final String OVERRIDE = "Override";
    private static final String FQ_OVERRIDE = "java.lang.Override";
    private static final DetailAST[] EMPTY_DETAILAST_ARRAY = new DetailAST[0];
    private boolean checkPublicMethods = true;
    private boolean checkProtectedMethods = true;
    private boolean checkPackageMethods = true;
    private boolean checkPrivateMethods;
    private boolean checkOverrideMethods;
    private boolean checkDeprecatedMethods;
    private boolean allowReturnWildcardWithSuper;
    private boolean allowReturnWildcardWithExtends;
    private Pattern returnTypeClassNamesIgnoreRegex = Pattern.compile("^(Comparator|Comparable)$");

    public void setCheckPublicMethods(boolean checkPublicMethods) {
        this.checkPublicMethods = checkPublicMethods;
    }

    public void setCheckProtectedMethods(boolean checkProtectedMethods) {
        this.checkProtectedMethods = checkProtectedMethods;
    }

    public void setCheckPackageMethods(boolean checkPackageMethods) {
        this.checkPackageMethods = checkPackageMethods;
    }

    public void setCheckPrivateMethods(boolean checkPrivateMethods) {
        this.checkPrivateMethods = checkPrivateMethods;
    }

    public void setCheckOverrideMethods(boolean checkOverrideMethods) {
        this.checkOverrideMethods = checkOverrideMethods;
    }

    public void setCheckDeprecatedMethods(boolean checkDeprecatedMethods) {
        this.checkDeprecatedMethods = checkDeprecatedMethods;
    }

    public void setAllowReturnWildcardWithSuper(boolean allowReturnWildcardWithSuper) {
        this.allowReturnWildcardWithSuper = allowReturnWildcardWithSuper;
    }

    public void setAllowReturnWildcardWithExtends(boolean allowReturnWildcardWithExtends) {
        this.allowReturnWildcardWithExtends = allowReturnWildcardWithExtends;
    }

    public void setReturnTypeClassNamesIgnoreRegex(String returnTypeClassNamesIgnoreRegex) {
        this.returnTypeClassNamesIgnoreRegex = Pattern.compile(returnTypeClassNamesIgnoreRegex);
    }

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public void visitToken(DetailAST methodDefAst) {
        List<DetailAST> wildcardTypeArguments;
        String methodScope = ForbidWildcardAsReturnTypeCheck.getVisibilityScope(methodDefAst);
        if ((this.checkPublicMethods && "public".equals(methodScope) || this.checkPrivateMethods && "private".equals(methodScope) || this.checkProtectedMethods && "protected".equals(methodScope) || this.checkPackageMethods && "package".equals(methodScope)) && (this.checkOverrideMethods || !AnnotationUtility.containsAnnotation((DetailAST)methodDefAst, (String)OVERRIDE) && !AnnotationUtility.containsAnnotation((DetailAST)methodDefAst, (String)FQ_OVERRIDE)) && (this.checkDeprecatedMethods || !AnnotationUtility.containsAnnotation((DetailAST)methodDefAst, (String)DEPRECATED) && !AnnotationUtility.containsAnnotation((DetailAST)methodDefAst, (String)FQ_DEPRECATED)) && !(wildcardTypeArguments = ForbidWildcardAsReturnTypeCheck.getWildcardArgumentsAsMethodReturnType(methodDefAst)).isEmpty() && !this.isIgnoreCase(methodDefAst, wildcardTypeArguments)) {
            this.log(methodDefAst.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private static String getVisibilityScope(DetailAST methodDefAst) {
        String result = "package";
        if (ForbidWildcardAsReturnTypeCheck.isInsideInterfaceDefinition(methodDefAst)) {
            result = "public";
        } else {
            String[] visibilityScopeModifiers = new String[]{"public", "private", "protected"};
            Set<String> methodModifiers = ForbidWildcardAsReturnTypeCheck.getModifiers(methodDefAst);
            for (String modifier : visibilityScopeModifiers) {
                if (!methodModifiers.contains(modifier)) continue;
                result = modifier;
                break;
            }
        }
        return result;
    }

    private static boolean isInsideInterfaceDefinition(DetailAST methodDefAst) {
        boolean result = false;
        DetailAST objBlock = methodDefAst.getParent();
        DetailAST interfaceDef = objBlock.getParent();
        if (interfaceDef.getType() == 15) {
            result = true;
        }
        return result;
    }

    private static Set<String> getModifiers(DetailAST methodDefAst) {
        DetailAST modifiersAst = methodDefAst.getFirstChild();
        HashSet<String> modifiersSet = new HashSet<String>();
        for (AST modifierAst = modifiersAst.getFirstChild(); modifierAst != null; modifierAst = modifierAst.getNextSibling()) {
            modifiersSet.add(modifierAst.getText());
        }
        return modifiersSet;
    }

    private static String getIdentifier(DetailAST ast) {
        DetailAST identifier = ast.findFirstToken(58);
        String result = identifier.getText();
        return result;
    }

    private static List<DetailAST> getWildcardArgumentsAsMethodReturnType(DetailAST methodDefAst) {
        DetailAST[] methodTypeArgumentTokens;
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        DetailAST methodTypeAst = methodDefAst.findFirstToken(13);
        for (DetailAST typeArgumentAst : methodTypeArgumentTokens = ForbidWildcardAsReturnTypeCheck.getGenericTypeArguments(methodTypeAst)) {
            if (!ForbidWildcardAsReturnTypeCheck.hasChildToken(typeArgumentAst, 167)) continue;
            result.add(typeArgumentAst);
        }
        return result;
    }

    private static DetailAST[] getGenericTypeArguments(DetailAST typeAst) {
        DetailAST[] result = EMPTY_DETAILAST_ARRAY;
        if (ForbidWildcardAsReturnTypeCheck.hasChildToken(typeAst, 163)) {
            DetailAST typeArguments = typeAst.findFirstToken(163);
            int argumentsCount = typeArguments.getChildCount(164);
            result = new DetailAST[argumentsCount];
            int counter = 0;
            for (DetailAST firstTypeArgument = typeArguments.findFirstToken(164); firstTypeArgument != null; firstTypeArgument = firstTypeArgument.getNextSibling()) {
                if (firstTypeArgument.getType() != 164) continue;
                result[counter] = firstTypeArgument;
                ++counter;
            }
        }
        return result;
    }

    private static boolean hasChildToken(DetailAST ast, int tokenType) {
        return ast.findFirstToken(tokenType) != null;
    }

    private boolean isIgnoreCase(DetailAST methodDefAst, List<DetailAST> wildcardTypeArguments) {
        boolean result = false;
        if (this.matchesIgnoreClassNames(methodDefAst)) {
            result = true;
        } else {
            boolean hasExtendsWildcardAsReturnType = ForbidWildcardAsReturnTypeCheck.hasBoundedWildcardAsReturnType(wildcardTypeArguments, 168);
            boolean hasSuperWildcardAsReturnType = ForbidWildcardAsReturnTypeCheck.hasBoundedWildcardAsReturnType(wildcardTypeArguments, 169);
            boolean hasOnlyExtendsWildcardAsReturnType = hasExtendsWildcardAsReturnType && !hasSuperWildcardAsReturnType;
            boolean hasOnlySuperWildcardAsReturnType = hasSuperWildcardAsReturnType && !hasExtendsWildcardAsReturnType;
            boolean hasBoundedWildcardAsReturnType = hasExtendsWildcardAsReturnType || hasSuperWildcardAsReturnType;
            boolean isAllowedBoundedWildcards = this.allowReturnWildcardWithExtends && this.allowReturnWildcardWithSuper;
            result = isAllowedBoundedWildcards && hasBoundedWildcardAsReturnType || this.allowReturnWildcardWithExtends && hasOnlyExtendsWildcardAsReturnType || this.allowReturnWildcardWithSuper && hasOnlySuperWildcardAsReturnType;
        }
        return result;
    }

    private boolean matchesIgnoreClassNames(DetailAST methodDefAst) {
        DetailAST methodTypeAst = methodDefAst.findFirstToken(13);
        String typeIdentifier = ForbidWildcardAsReturnTypeCheck.getIdentifier(methodTypeAst);
        return this.returnTypeClassNamesIgnoreRegex.matcher(typeIdentifier).matches();
    }

    private static boolean hasBoundedWildcardAsReturnType(List<DetailAST> typeArgumentsList, int boundedWildcardType) {
        boolean result = false;
        for (DetailAST typeArgumentAst : typeArgumentsList) {
            if (!ForbidWildcardAsReturnTypeCheck.hasChildToken(typeArgumentAst, boundedWildcardType)) continue;
            result = true;
            break;
        }
        return result;
    }
}

