/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.regex.Pattern;

public class NameConventionForJunit4TestClassesCheck
extends AbstractCheck {
    public static final String MSG_KEY = "name.convention.for.test.classes";
    private Pattern expectedClassNameRegex = Pattern.compile(".+Test\\d*|.+Tests\\d*|Test.+|Tests.+|.+IT|.+ITs|.+TestCase\\d*|.+TestCases\\d*");
    private Pattern classAnnotationNameRegex;
    private Pattern methodAnnotationNameRegex = Pattern.compile("Test|org.junit.Test");

    public void setExpectedClassNameRegex(String expectedClassNameRegex) {
        this.expectedClassNameRegex = expectedClassNameRegex != null && !expectedClassNameRegex.isEmpty() ? Pattern.compile(expectedClassNameRegex) : null;
    }

    public void setClassAnnotationNameRegex(String annotationNameRegex) {
        this.classAnnotationNameRegex = annotationNameRegex != null && !annotationNameRegex.isEmpty() ? Pattern.compile(annotationNameRegex) : null;
    }

    public void setMethodAnnotationNameRegex(String annotationNameRegex) {
        this.methodAnnotationNameRegex = annotationNameRegex != null && !annotationNameRegex.isEmpty() ? Pattern.compile(annotationNameRegex) : null;
    }

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public void visitToken(DetailAST classDefNode) {
        if ((this.isClassDefinitionAnnotated(classDefNode) || this.isAtleastOneMethodAnnotated(classDefNode)) && this.hasUnexpectedName(classDefNode)) {
            this.logUnexpectedClassName(classDefNode);
        }
    }

    private boolean isClassDefinitionAnnotated(DetailAST classDefNode) {
        return NameConventionForJunit4TestClassesCheck.hasAnnotation(classDefNode, this.classAnnotationNameRegex);
    }

    private boolean isAtleastOneMethodAnnotated(DetailAST classDefNode) {
        for (DetailAST classMemberNode = classDefNode.findFirstToken(6).getFirstChild(); classMemberNode != null; classMemberNode = classMemberNode.getNextSibling()) {
            if (classMemberNode.getType() != 9 || !NameConventionForJunit4TestClassesCheck.hasAnnotation(classMemberNode, this.methodAnnotationNameRegex)) continue;
            return true;
        }
        return false;
    }

    private boolean hasUnexpectedName(DetailAST classDefNode) {
        String className = NameConventionForJunit4TestClassesCheck.getIdentifierName(classDefNode);
        return !NameConventionForJunit4TestClassesCheck.isMatchesRegex(this.expectedClassNameRegex, className);
    }

    private static boolean hasAnnotation(DetailAST methodOrClassDefNode, Pattern annotationNamesRegexp) {
        boolean result = false;
        for (DetailAST modifierNode = methodOrClassDefNode.findFirstToken(5).getFirstChild(); modifierNode != null; modifierNode = modifierNode.getNextSibling()) {
            String annotationName;
            if (modifierNode.getType() != 159 || !NameConventionForJunit4TestClassesCheck.isMatchesRegex(annotationNamesRegexp, annotationName = NameConventionForJunit4TestClassesCheck.getIdentifierName(modifierNode))) continue;
            result = true;
            break;
        }
        return result;
    }

    private void logUnexpectedClassName(DetailAST classDef) {
        this.log(classDef.findFirstToken(58), MSG_KEY, new Object[]{this.expectedClassNameRegex});
    }

    private static String getIdentifierName(DetailAST identifierNode) {
        String result;
        DetailAST identNode = identifierNode.findFirstToken(58);
        if (identNode != null) {
            result = identNode.getText();
        } else {
            result = "";
            DetailAST node = identifierNode.findFirstToken(59);
            while (node.getType() == 59) {
                result = "." + node.getLastChild().getText() + result;
                node = node.getFirstChild();
            }
            result = node.getText() + result;
        }
        return result;
    }

    private static boolean isMatchesRegex(Pattern regexPattern, String str) {
        if (regexPattern != null) {
            return regexPattern.matcher(str).matches();
        }
        return false;
    }
}

