/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;

public class MoveVariableInsideIfCheck
extends AbstractCheck {
    public static final String MSG_KEY = "move.variable.inside";

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        if (ScopeUtils.isLocalVariableDef((DetailAST)ast)) {
            this.validateLocalVariable(ast);
        }
    }

    private void validateLocalVariable(DetailAST ast) {
        Holder holder = new Holder(ast);
        block3: for (DetailAST child = ast.getNextSibling(); !holder.exit && child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 83: {
                    MoveVariableInsideIfCheck.validateIf(holder, child);
                    continue block3;
                }
                default: {
                    MoveVariableInsideIfCheck.validateOther(holder, child);
                }
            }
        }
        if (holder.blockNode != null) {
            this.log(ast, MSG_KEY, new Object[]{holder.variableName, holder.blockNode.getLineNo()});
        }
    }

    private static void validateIf(Holder holder, DetailAST ifNodeGiven) {
        block3: {
            DetailAST elseNode;
            DetailAST ifNode = ifNodeGiven;
            do {
                DetailAST body;
                DetailAST rparen = ifNode.findFirstToken(77);
                boolean usedInCondition = holder.hasIdent(ifNode.findFirstToken(76), rparen);
                if (usedInCondition) {
                    holder.setExit();
                    break block3;
                }
                elseNode = ifNode.getLastChild();
                DetailAST bodyEnd = (body = rparen.getNextSibling()).getType() == 7 ? body.getLastChild() : elseNode;
                boolean used = holder.hasIdent(body, bodyEnd);
                if (used) {
                    holder.setBlockNode(ifNode);
                    if (holder.exit) break block3;
                }
                if (elseNode.getType() != 92) break block3;
            } while ((ifNode = elseNode.getFirstChild()).getType() == 83);
            MoveVariableInsideIfCheck.validateElseOfIf(holder, ifNode, elseNode);
        }
    }

    private static void validateElseOfIf(Holder holder, DetailAST ifNode, DetailAST elseNode) {
        boolean used = ifNode.getType() == 7 ? holder.hasIdent(ifNode.getFirstChild(), ifNode.getLastChild()) : holder.hasIdent(ifNode, elseNode.getLastChild());
        if (used) {
            holder.setBlockNode(elseNode);
        }
    }

    private static void validateOther(Holder holder, DetailAST child) {
        boolean used = holder.hasIdent(child, child.getNextSibling());
        if (used) {
            holder.setExit();
        }
    }

    private static class Holder {
        private String variableName;
        private boolean exit;
        private DetailAST blockNode;

        Holder(DetailAST ast) {
            this.variableName = ast.findFirstToken(58).getText();
        }

        public void setBlockNode(DetailAST blockNode) {
            if (this.blockNode != null) {
                this.setExit();
            } else {
                this.blockNode = blockNode;
            }
        }

        public void setExit() {
            this.blockNode = null;
            this.exit = true;
        }

        public boolean hasIdent(DetailAST start, DetailAST end) {
            boolean found = false;
            DetailAST curNode = start;
            while (curNode != null) {
                if (curNode.getType() == 58 && this.variableName.equals(curNode.getText())) {
                    found = true;
                    break;
                }
                if (curNode == end) break;
                DetailAST toVisit = curNode.getFirstChild();
                while (toVisit == null) {
                    toVisit = curNode.getNextSibling();
                    if (toVisit != null) continue;
                    if (end == null) break;
                    curNode = curNode.getParent();
                }
                curNode = toVisit;
            }
            return found;
        }
    }
}

