/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class LogicConditionNeedOptimizationCheck
extends AbstractCheck {
    public static final String MSG_KEY = "logic.condition.need.optimization";

    public int[] getDefaultTokens() {
        return new int[]{111, 110};
    }

    public void visitToken(DetailAST detailAST) {
        if (LogicConditionNeedOptimizationCheck.needOptimization(detailAST)) {
            this.log(detailAST.getLineNo(), MSG_KEY, new Object[]{detailAST.getText(), detailAST.getLineNo(), detailAST.getColumnNo()});
        }
    }

    private static boolean needOptimization(DetailAST logicNode) {
        DetailAST secondOperand = LogicConditionNeedOptimizationCheck.getSecondOperand(logicNode);
        return !secondOperand.branchContains(27) && logicNode.branchContains(27);
    }

    private static DetailAST getSecondOperand(DetailAST logicNode) {
        DetailAST child = logicNode.getLastChild();
        if (child.getType() == 77) {
            child = child.getPreviousSibling();
        }
        return child;
    }
}

