/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.LinkedList;
import java.util.List;

public class AvoidHidingCauseExceptionCheck
extends AbstractCheck {
    public static final String MSG_KEY = "avoid.hiding.cause.exception";

    public int[] getDefaultTokens() {
        return new int[]{96};
    }

    public void visitToken(DetailAST detailAST) {
        String originExcName = detailAST.findFirstToken(21).getLastChild().getText();
        List<DetailAST> throwList = this.makeThrowList(detailAST);
        LinkedList<String> wrapExcNames = new LinkedList<String>();
        wrapExcNames.add(originExcName);
        wrapExcNames.addAll(this.makeExceptionsList(detailAST, detailAST, originExcName));
        for (DetailAST throwAST : throwList) {
            LinkedList<DetailAST> throwParamNamesList = new LinkedList<DetailAST>();
            this.buildThrowParamNamesList(throwAST, throwParamNamesList);
            if (AvoidHidingCauseExceptionCheck.isContainsCaughtExc(throwParamNamesList, wrapExcNames)) continue;
            this.log(throwAST, MSG_KEY, new Object[]{originExcName});
        }
    }

    private static boolean isContainsCaughtExc(List<DetailAST> throwParamNamesList, List<String> wrapExcNames) {
        boolean result = false;
        for (DetailAST currentNode : throwParamNamesList) {
            if (currentNode.getParent().getType() == 59 || !wrapExcNames.contains(currentNode.getText())) continue;
            result = true;
            break;
        }
        return result;
    }

    private List<DetailAST> buildThrowParamNamesList(DetailAST startNode, List<DetailAST> paramNamesAST) {
        for (DetailAST currentNode : AvoidHidingCauseExceptionCheck.getChildNodes(startNode)) {
            if (currentNode.getType() == 58) {
                paramNamesAST.add(currentNode);
            }
            if (currentNode.getType() == 21 || currentNode.getType() == 95 || currentNode.getNumberOfChildren() <= 0) continue;
            this.buildThrowParamNamesList(currentNode, paramNamesAST);
        }
        return paramNamesAST;
    }

    private List<DetailAST> makeThrowList(DetailAST parentAST) {
        LinkedList<DetailAST> throwList = new LinkedList<DetailAST>();
        for (DetailAST currentNode : AvoidHidingCauseExceptionCheck.getChildNodes(parentAST)) {
            if (currentNode.getType() == 90) {
                throwList.add(currentNode);
            }
            if (currentNode.getType() == 21 || currentNode.getType() == 90 || currentNode.getType() == 95 || currentNode.getNumberOfChildren() <= 0) continue;
            throwList.addAll(this.makeThrowList(currentNode));
        }
        return throwList;
    }

    private List<String> makeExceptionsList(DetailAST currentCatchAST, DetailAST parentAST, String currentExcName) {
        LinkedList<String> wrapExcNames = new LinkedList<String>();
        for (DetailAST currentNode : AvoidHidingCauseExceptionCheck.getChildNodes(parentAST)) {
            if (currentNode.getType() == 58 && currentNode.getText().equals(currentExcName) && currentNode.getParent().getType() != 59) {
                DetailAST temp = currentNode;
                while (!temp.equals((AST)currentCatchAST) && temp.getType() != 80) {
                    temp = temp.getParent();
                }
                if (temp.getType() == 80) {
                    DetailAST convertedExc = null;
                    convertedExc = temp.getParent().getType() == 10 ? temp.getParent().findFirstToken(58) : temp.findFirstToken(58);
                    if (convertedExc != null) {
                        wrapExcNames.add(convertedExc.getText());
                    }
                }
            }
            if (currentNode.getType() == 21 || currentNode.getNumberOfChildren() <= 0) continue;
            wrapExcNames.addAll(this.makeExceptionsList(currentCatchAST, currentNode, currentExcName));
        }
        return wrapExcNames;
    }

    private static List<DetailAST> getChildNodes(DetailAST node) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST currNode = node.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            result.add(currNode);
        }
        return result;
    }
}

