/*
 * Decompiled with CFR 0.152.
 */
package com.github.qcloudsms;

import com.github.qcloudsms.SmsSenderUtil;
import com.github.qcloudsms.SmsSingleVoiceSenderResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import org.json.JSONObject;

public class SmsSingleVoiceSender {
    int appid;
    String appkey;
    String url = "https://test.tim.qq.com/v3/tlsvoicesvr/sendvoiceprompt";
    SmsSenderUtil util = new SmsSenderUtil();

    public SmsSingleVoiceSender(int appid, String appkey) {
        this.appid = appid;
        this.appkey = appkey;
    }

    public SmsSingleVoiceSenderResult send(String nationCode, String phoneNumber, int type, String fileName, String ext) throws Exception {
        SmsSingleVoiceSenderResult result;
        if (3 != type) {
            throw new Exception("type " + type + " error");
        }
        if (null == ext) {
            ext = "";
        }
        JSONObject data = new JSONObject();
        JSONObject tel = new JSONObject();
        tel.put("nationcode", (Object)nationCode);
        tel.put("phone", (Object)phoneNumber);
        data.put("tel", (Object)tel);
        data.put("prompttype", type);
        data.put("promptfile", (Object)fileName);
        data.put("sig", (Object)this.util.stringMD5(this.appkey + phoneNumber));
        data.put("ext", (Object)ext);
        String wholeUrl = String.format("%s?sdkappid=%d", this.url, this.appid);
        HttpURLConnection conn = this.util.getPostHttpConn(wholeUrl);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), "utf-8");
        wr.write(data.toString());
        wr.flush();
        StringBuilder sb = new StringBuilder();
        int httpRspCode = conn.getResponseCode();
        if (httpRspCode == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            JSONObject json = new JSONObject(sb.toString());
            result = this.util.jsonToSmsSingleVoiceSenderResult(json);
        } else {
            result = new SmsSingleVoiceSenderResult();
            result.result = httpRspCode;
            result.errmsg = "http error " + httpRspCode + " " + conn.getResponseMessage();
        }
        return result;
    }
}

