/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt.entity.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.plexpt.chatgpt.entity.chat.ChatFunction;
import com.plexpt.chatgpt.entity.chat.Message;
import com.plexpt.chatgpt.entity.chat.ResponseFormat;
import com.plexpt.chatgpt.util.TokensUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ChatCompletion
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ChatCompletion.class);
    @NonNull
    private String model;
    @NonNull
    private List<Message> messages;
    private double temperature;
    @JsonProperty(value="top_p")
    private double topP;
    String function_call;
    List<ChatFunction> functions;
    private Integer n;
    private boolean stream;
    private List<String> stop;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    private double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private double frequencyPenalty;
    @JsonProperty(value="logit_bias")
    private Map logitBias;
    private String user;
    @JsonProperty(value="response_format")
    private ResponseFormat responseFormat;

    public int countTokens() {
        return TokensUtil.tokens(this.model, this.messages);
    }

    private static String $default$model() {
        return Model.GPT_3_5_TURBO_0613.getName();
    }

    private static double $default$temperature() {
        return 0.9;
    }

    private static double $default$topP() {
        return 0.9;
    }

    private static Integer $default$n() {
        return 1;
    }

    private static boolean $default$stream() {
        return false;
    }

    public static ChatCompletionBuilder builder() {
        return new ChatCompletionBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<Message> getMessages() {
        return this.messages;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getTopP() {
        return this.topP;
    }

    public String getFunction_call() {
        return this.function_call;
    }

    public List<ChatFunction> getFunctions() {
        return this.functions;
    }

    public Integer getN() {
        return this.n;
    }

    public boolean isStream() {
        return this.stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setMessages(@NonNull List<Message> messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(double topP) {
        this.topP = topP;
    }

    public void setFunction_call(String function_call) {
        this.function_call = function_call;
    }

    public void setFunctions(List<ChatFunction> functions) {
        this.functions = functions;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @JsonProperty(value="response_format")
    public void setResponseFormat(ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletion)) {
            return false;
        }
        ChatCompletion other = (ChatCompletion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (Double.compare(this.getTopP(), other.getTopP()) != 0) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (Double.compare(this.getPresencePenalty(), other.getPresencePenalty()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrequencyPenalty(), other.getFrequencyPenalty()) != 0) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$function_call = this.getFunction_call();
        String other$function_call = other.getFunction_call();
        if (this$function_call == null ? other$function_call != null : !this$function_call.equals(other$function_call)) {
            return false;
        }
        List<ChatFunction> this$functions = this.getFunctions();
        List<ChatFunction> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map this$logitBias = this.getLogitBias();
        Map other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        ResponseFormat this$responseFormat = this.getResponseFormat();
        ResponseFormat other$responseFormat = other.getResponseFormat();
        return !(this$responseFormat == null ? other$responseFormat != null : !((Object)this$responseFormat).equals(other$responseFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        long $topP = Double.doubleToLongBits(this.getTopP());
        result = result * 59 + (int)($topP >>> 32 ^ $topP);
        result = result * 59 + (this.isStream() ? 79 : 97);
        long $presencePenalty = Double.doubleToLongBits(this.getPresencePenalty());
        result = result * 59 + (int)($presencePenalty >>> 32 ^ $presencePenalty);
        long $frequencyPenalty = Double.doubleToLongBits(this.getFrequencyPenalty());
        result = result * 59 + (int)($frequencyPenalty >>> 32 ^ $frequencyPenalty);
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $function_call = this.getFunction_call();
        result = result * 59 + ($function_call == null ? 43 : $function_call.hashCode());
        List<ChatFunction> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        ResponseFormat $responseFormat = this.getResponseFormat();
        result = result * 59 + ($responseFormat == null ? 43 : ((Object)$responseFormat).hashCode());
        return result;
    }

    public String toString() {
        return "ChatCompletion(model=" + this.getModel() + ", messages=" + this.getMessages() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", function_call=" + this.getFunction_call() + ", functions=" + this.getFunctions() + ", n=" + this.getN() + ", stream=" + this.isStream() + ", stop=" + this.getStop() + ", maxTokens=" + this.getMaxTokens() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ", responseFormat=" + this.getResponseFormat() + ")";
    }

    public ChatCompletion(@NonNull String model, @NonNull List<Message> messages, double temperature, double topP, String function_call, List<ChatFunction> functions, Integer n, boolean stream, List<String> stop, Integer maxTokens, double presencePenalty, double frequencyPenalty, Map logitBias, String user, ResponseFormat responseFormat) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.model = model;
        this.messages = messages;
        this.temperature = temperature;
        this.topP = topP;
        this.function_call = function_call;
        this.functions = functions;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.user = user;
        this.responseFormat = responseFormat;
    }

    public ChatCompletion() {
        this.model = ChatCompletion.$default$model();
        this.temperature = ChatCompletion.$default$temperature();
        this.topP = ChatCompletion.$default$topP();
        this.n = ChatCompletion.$default$n();
        this.stream = ChatCompletion.$default$stream();
    }

    public static class ChatCompletionBuilder {
        private boolean model$set;
        private String model$value;
        private List<Message> messages;
        private boolean temperature$set;
        private double temperature$value;
        private boolean topP$set;
        private double topP$value;
        private String function_call;
        private List<ChatFunction> functions;
        private boolean n$set;
        private Integer n$value;
        private boolean stream$set;
        private boolean stream$value;
        private List<String> stop;
        private Integer maxTokens;
        private double presencePenalty;
        private double frequencyPenalty;
        private Map logitBias;
        private String user;
        private ResponseFormat responseFormat;

        ChatCompletionBuilder() {
        }

        public ChatCompletionBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public ChatCompletionBuilder messages(@NonNull List<Message> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
            return this;
        }

        public ChatCompletionBuilder temperature(double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatCompletionBuilder topP(double topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        public ChatCompletionBuilder function_call(String function_call) {
            this.function_call = function_call;
            return this;
        }

        public ChatCompletionBuilder functions(List<ChatFunction> functions) {
            this.functions = functions;
            return this;
        }

        public ChatCompletionBuilder n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return this;
        }

        public ChatCompletionBuilder stream(boolean stream) {
            this.stream$value = stream;
            this.stream$set = true;
            return this;
        }

        public ChatCompletionBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public ChatCompletionBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public ChatCompletionBuilder presencePenalty(double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public ChatCompletionBuilder frequencyPenalty(double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public ChatCompletionBuilder logitBias(Map logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public ChatCompletionBuilder user(String user) {
            this.user = user;
            return this;
        }

        @JsonProperty(value="response_format")
        public ChatCompletionBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public ChatCompletion build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = ChatCompletion.$default$model();
            }
            double temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = ChatCompletion.$default$temperature();
            }
            double topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = ChatCompletion.$default$topP();
            }
            Integer n$value = this.n$value;
            if (!this.n$set) {
                n$value = ChatCompletion.$default$n();
            }
            boolean stream$value = this.stream$value;
            if (!this.stream$set) {
                stream$value = ChatCompletion.$default$stream();
            }
            return new ChatCompletion(model$value, this.messages, temperature$value, topP$value, this.function_call, this.functions, n$value, stream$value, this.stop, this.maxTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.user, this.responseFormat);
        }

        public String toString() {
            return "ChatCompletion.ChatCompletionBuilder(model$value=" + this.model$value + ", messages=" + this.messages + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", function_call=" + this.function_call + ", functions=" + this.functions + ", n$value=" + this.n$value + ", stream$value=" + this.stream$value + ", stop=" + this.stop + ", maxTokens=" + this.maxTokens + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", user=" + this.user + ", responseFormat=" + this.responseFormat + ")";
        }
    }

    public static enum Model {
        GPT_3_5_TURBO("gpt-3.5-turbo"),
        GPT_3_5_TURBO_0613("gpt-3.5-turbo-0613"),
        GPT_3_5_TURBO_16K("gpt-3.5-turbo-16k"),
        GPT_3_5_TURBO_0301("gpt-3.5-turbo-0301"),
        GPT_3_5_TURBO_1106("gpt-3.5-turbo-1106"),
        GPT_3_5_TURBO_INSTRUCT("gpt-3.5-turbo-instruct"),
        GPT_4("gpt-4"),
        GPT4Turbo("gpt-4-1106-preview"),
        GPT_4VP("gpt-4-vision-preview"),
        GPT_4_0314("gpt-4-0314"),
        GPT_4_0613("gpt-4-0613"),
        GPT_4_32K("gpt-4-32k"),
        GPT_4_32K_0613("gpt-4-32k-0613"),
        GPT_4_32K_0314("gpt-4-32k-0314");

        private String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

