/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import com.alibaba.fastjson.JSON;
import com.plexpt.chatgpt.api.Api;
import com.plexpt.chatgpt.entity.BaseResponse;
import com.plexpt.chatgpt.entity.audio.AudioResponse;
import com.plexpt.chatgpt.entity.audio.Transcriptions;
import com.plexpt.chatgpt.exception.ChatException;
import io.reactivex.Single;
import java.io.File;
import java.net.Proxy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class Audio {
    private static final Logger log = LoggerFactory.getLogger(Audio.class);
    private String apiKey;
    private List<String> apiKeyList;
    private String apiHost;
    private Api apiClient;
    private OkHttpClient okHttpClient;
    private long timeout;
    private Proxy proxy;

    public Audio init() {
        OkHttpClient httpClient;
        OkHttpClient.Builder client = new OkHttpClient.Builder();
        client.addInterceptor(chain -> {
            Request original = chain.request();
            String key = this.apiKey;
            if (this.apiKeyList != null && !this.apiKeyList.isEmpty()) {
                key = (String)RandomUtil.randomEle(this.apiKeyList);
            }
            Request request = original.newBuilder().header(Header.AUTHORIZATION.getValue(), "Bearer " + key).header(Header.CONTENT_TYPE.getValue(), ContentType.JSON.getValue()).method(original.method(), original.body()).build();
            return chain.proceed(request);
        }).addInterceptor(chain -> {
            Request original = chain.request();
            Response response = chain.proceed(original);
            if (!response.isSuccessful()) {
                String errorMsg = response.body().string();
                log.error("\u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)errorMsg);
                BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)errorMsg, BaseResponse.class);
                if (Objects.nonNull(baseResponse.getError())) {
                    log.error(baseResponse.getError().getMessage());
                    throw new ChatException(baseResponse.getError().getMessage());
                }
                throw new ChatException("error");
            }
            return response;
        });
        client.connectTimeout(this.timeout, TimeUnit.SECONDS);
        client.writeTimeout(this.timeout, TimeUnit.SECONDS);
        client.readTimeout(this.timeout, TimeUnit.SECONDS);
        if (Objects.nonNull(this.proxy)) {
            client.proxy(this.proxy);
        }
        this.okHttpClient = httpClient = client.build();
        this.apiClient = (Api)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(Api.class);
        return this;
    }

    public AudioResponse transcriptions(File audio, Transcriptions transcriptions) {
        RequestBody a = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data;charset=UTF-8"), (File)audio);
        MultipartBody.Part aPart = MultipartBody.Part.createFormData((String)"image", (String)audio.getName(), (RequestBody)a);
        Single<AudioResponse> audioResponse = this.apiClient.audioTranscriptions(aPart, transcriptions);
        return (AudioResponse)audioResponse.blockingGet();
    }

    public AudioResponse translations(File audio, Transcriptions transcriptions) {
        RequestBody a = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data;charset=UTF-8"), (File)audio);
        MultipartBody.Part aPart = MultipartBody.Part.createFormData((String)"image", (String)audio.getName(), (RequestBody)a);
        Single<AudioResponse> audioResponse = this.apiClient.audioTranslations(aPart, transcriptions);
        return (AudioResponse)audioResponse.blockingGet();
    }

    private static String $default$apiHost() {
        return "https://api.openai.com/";
    }

    private static long $default$timeout() {
        return 300L;
    }

    private static Proxy $default$proxy() {
        return Proxy.NO_PROXY;
    }

    public static AudioBuilder builder() {
        return new AudioBuilder();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public List<String> getApiKeyList() {
        return this.apiKeyList;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public Api getApiClient() {
        return this.apiClient;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setApiKeyList(List<String> apiKeyList) {
        this.apiKeyList = apiKeyList;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public void setApiClient(Api apiClient) {
        this.apiClient = apiClient;
    }

    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Audio(String apiKey, List<String> apiKeyList, String apiHost, Api apiClient, OkHttpClient okHttpClient, long timeout, Proxy proxy) {
        this.apiKey = apiKey;
        this.apiKeyList = apiKeyList;
        this.apiHost = apiHost;
        this.apiClient = apiClient;
        this.okHttpClient = okHttpClient;
        this.timeout = timeout;
        this.proxy = proxy;
    }

    public Audio() {
        this.apiHost = Audio.$default$apiHost();
        this.timeout = Audio.$default$timeout();
        this.proxy = Audio.$default$proxy();
    }

    public static class AudioBuilder {
        private String apiKey;
        private List<String> apiKeyList;
        private boolean apiHost$set;
        private String apiHost$value;
        private Api apiClient;
        private OkHttpClient okHttpClient;
        private boolean timeout$set;
        private long timeout$value;
        private boolean proxy$set;
        private Proxy proxy$value;

        AudioBuilder() {
        }

        public AudioBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public AudioBuilder apiKeyList(List<String> apiKeyList) {
            this.apiKeyList = apiKeyList;
            return this;
        }

        public AudioBuilder apiHost(String apiHost) {
            this.apiHost$value = apiHost;
            this.apiHost$set = true;
            return this;
        }

        public AudioBuilder apiClient(Api apiClient) {
            this.apiClient = apiClient;
            return this;
        }

        public AudioBuilder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public AudioBuilder timeout(long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        public AudioBuilder proxy(Proxy proxy) {
            this.proxy$value = proxy;
            this.proxy$set = true;
            return this;
        }

        public Audio build() {
            String apiHost$value = this.apiHost$value;
            if (!this.apiHost$set) {
                apiHost$value = Audio.$default$apiHost();
            }
            long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = Audio.$default$timeout();
            }
            Proxy proxy$value = this.proxy$value;
            if (!this.proxy$set) {
                proxy$value = Audio.$default$proxy();
            }
            return new Audio(this.apiKey, this.apiKeyList, apiHost$value, this.apiClient, this.okHttpClient, timeout$value, proxy$value);
        }

        public String toString() {
            return "Audio.AudioBuilder(apiKey=" + this.apiKey + ", apiKeyList=" + this.apiKeyList + ", apiHost$value=" + this.apiHost$value + ", apiClient=" + this.apiClient + ", okHttpClient=" + this.okHttpClient + ", timeout$value=" + this.timeout$value + ", proxy$value=" + this.proxy$value + ")";
        }
    }
}

