/*
 * Decompiled with CFR 0.152.
 */
package oshi.json;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import oshi.PlatformEnum;
import oshi.json.hardware.HardwareAbstractionLayer;
import oshi.json.hardware.impl.HardwareAbstractionLayerImpl;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.json.OshiJsonObject;
import oshi.json.software.os.OperatingSystem;
import oshi.json.software.os.impl.OperatingSystemImpl;
import oshi.json.util.PropertiesUtil;

public class SystemInfo
extends AbstractOshiJsonObject
implements OshiJsonObject {
    private static final long serialVersionUID = 1L;
    private oshi.SystemInfo si;
    private OperatingSystem os = null;
    private HardwareAbstractionLayer hardware = null;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);

    public SystemInfo() {
        this.si = new oshi.SystemInfo();
    }

    public static PlatformEnum getCurrentPlatformEnum() {
        return oshi.SystemInfo.getCurrentPlatformEnum();
    }

    public OperatingSystem getOperatingSystem() {
        if (this.os == null) {
            this.os = new OperatingSystemImpl(this.si.getOperatingSystem());
        }
        return this.os;
    }

    public HardwareAbstractionLayer getHardware() {
        if (this.hardware == null) {
            this.hardware = new HardwareAbstractionLayerImpl(this.si.getHardware());
        }
        return this.hardware;
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "platform")) {
            json.add("platform", SystemInfo.getCurrentPlatformEnum().toString());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem")) {
            json.add("operatingSystem", (JsonValue)this.getOperatingSystem().toJSON(properties));
        }
        if (PropertiesUtil.getBoolean(properties, "hardware")) {
            json.add("hardware", (JsonValue)this.getHardware().toJSON(properties));
        }
        return json.build();
    }
}

