/*
 * Decompiled with CFR 0.152.
 */
package com.github.odavid.maven.plugins;

import com.github.odavid.maven.plugins.Mixin;
import com.github.odavid.maven.plugins.MixinModelCache;
import com.github.odavid.maven.plugins.MixinModelMerger;
import com.github.odavid.maven.plugins.MixinModelProblemCollector;
import com.github.odavid.maven.plugins.Mixins;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.configuration.BeanConfigurationException;
import org.apache.maven.configuration.BeanConfigurationRequest;
import org.apache.maven.configuration.BeanConfigurator;
import org.apache.maven.configuration.DefaultBeanConfigurationRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.plugin.PluginConfigurationExpander;
import org.apache.maven.model.plugin.ReportingConverter;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileInjector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MixinsProjectLoader {
    public static final String PLUGIN_GROUPID = "com.github.odavid.maven.plugins";
    public static final String PLUGIN_ARTIFACTID = "mixin-maven-plugin";
    private MavenSession mavenSession;
    private MavenProject mavenProject;
    private ProfileSelector profileSelector;
    private ProfileInjector profileInjector;
    private MixinModelMerger mixinModelMerger;
    private ModelInterpolator modelInterpolator;
    private PluginConfigurationExpander pluginConfigurationExpander;
    private BeanConfigurator beanConfigurator;
    private ReportingConverter reportingConverter;
    private RepositorySystem repositorySystem;
    private DefaultModelBuildingRequest modelBuildingRequest = new DefaultModelBuildingRequest();
    private MixinModelCache mixinModelCache;
    private Logger logger;

    public MixinsProjectLoader(MavenSession mavenSession, MavenProject mavenProject, ModelInterpolator modelInterpolator, PluginConfigurationExpander pluginConfigurationExpander, BeanConfigurator beanConfigurator, Logger logger, MixinModelCache mixinModelCache, ProfileSelector profileSelector, ProfileInjector profileInjector, MixinModelMerger mixinModelMerger, ReportingConverter reportingConverter, RepositorySystem repositorySystem) {
        this.mavenSession = mavenSession;
        this.mavenProject = mavenProject;
        this.modelInterpolator = modelInterpolator;
        this.pluginConfigurationExpander = pluginConfigurationExpander;
        this.beanConfigurator = beanConfigurator;
        this.logger = logger;
        this.mixinModelCache = mixinModelCache;
        this.profileSelector = profileSelector;
        this.profileInjector = profileInjector;
        this.mixinModelMerger = mixinModelMerger;
        this.reportingConverter = reportingConverter;
        this.repositorySystem = repositorySystem;
        ProjectBuildingRequest projectBuildingRequest = mavenSession.getProjectBuildingRequest();
        this.modelBuildingRequest.setActiveProfileIds(projectBuildingRequest.getActiveProfileIds());
        this.modelBuildingRequest.setInactiveProfileIds(projectBuildingRequest.getInactiveProfileIds());
        this.modelBuildingRequest.setBuildStartTime(projectBuildingRequest.getBuildStartTime());
    }

    public void mergeMixins() throws MavenExecutionException {
        ArrayList<Mixin> mixinList = new ArrayList<Mixin>();
        HashMap<String, Mixin> mixinMap = new HashMap<String, Mixin>();
        this.fillMixins(mixinList, mixinMap, this.mavenProject.getModel());
        MixinModelProblemCollector problems = new MixinModelProblemCollector();
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest((ModelBuildingRequest)this.modelBuildingRequest);
        request.setSystemProperties(this.mavenSession.getSystemProperties());
        request.setUserProperties(this.mavenSession.getUserProperties());
        HashSet<String> mixinProfiles = new HashSet<String>();
        for (Mixin mixin : mixinList) {
            boolean hasReporting;
            this.logger.debug(String.format("Merging mixin: %s into %s", mixin.getKey(), this.mavenProject.getFile()));
            Model mixinModel = this.mixinModelCache.getModel(mixin, this.mavenProject);
            if (mixin.isActivateProfiles().booleanValue()) {
                this.logger.debug(String.format("Activating profiles in mixin: %s into %s", mixin.getKey(), this.mavenProject.getFile()));
                mixinModel = mixinModel.clone();
                List activePomProfiles = this.profileSelector.getActiveProfiles((Collection)mixinModel.getProfiles(), (ProfileActivationContext)this.getProfileActivationContext(), (ModelProblemCollector)problems);
                for (Profile profile : activePomProfiles) {
                    this.logger.debug(String.format("Activating profile %s in mixin: %s into %s", profile.getId(), mixin.getKey(), this.mavenProject.getFile()));
                    this.profileInjector.injectProfile(mixinModel, profile, (ModelBuildingRequest)this.modelBuildingRequest, (ModelProblemCollector)problems);
                    mixinProfiles.add(profile.getId());
                }
            }
            boolean bl = hasReporting = this.mavenProject.getModel().getReporting() != null;
            if (hasReporting) {
                this.removeSitePluginReportPlugins(this.mavenProject.getModel());
            }
            mixin.merge(mixinModel, this.mavenProject, this.mavenSession, this.mixinModelMerger);
            if (!hasReporting) continue;
            this.reportingConverter.convertReporting(this.mavenProject.getModel(), (ModelBuildingRequest)request, (ModelProblemCollector)problems);
        }
        if (mixinList.size() > 0) {
            this.mixinModelMerger.applyPluginManagementOnPlugins(this.mavenProject.getModel());
            this.modelInterpolator.interpolateModel(this.mavenProject.getModel(), this.mavenProject.getBasedir(), (ModelBuildingRequest)request, (ModelProblemCollector)problems);
            this.pluginConfigurationExpander.expandPluginConfiguration(this.mavenProject.getModel(), (ModelBuildingRequest)request, (ModelProblemCollector)problems);
            if (this.mavenProject.getInjectedProfileIds().containsKey("pom")) {
                ((List)this.mavenProject.getInjectedProfileIds().get("pom")).addAll(mixinProfiles);
            } else {
                this.mavenProject.getInjectedProfileIds().put("pom", new ArrayList(mixinProfiles));
            }
            problems.checkErrors(this.mavenProject.getFile());
            this.setupMaven33DistributionManagement(this.mavenProject);
        }
    }

    private void removeSitePluginReportPlugins(Model model) {
        this.cleanSitePluginFromReportPlugins((PluginContainer)model.getBuild().getPluginManagement());
        this.cleanSitePluginFromReportPlugins((PluginContainer)model.getBuild());
    }

    private Plugin cleanSitePluginFromReportPlugins(PluginContainer pluginContainer) {
        if (pluginContainer == null) {
            return null;
        }
        Plugin sitePlugin = null;
        for (Plugin plugin : pluginContainer.getPlugins()) {
            if (!"maven-site-plugin".equals(plugin.getArtifactId()) || !"org.apache.maven.plugins".equals(plugin.getGroupId())) continue;
            sitePlugin = plugin;
            break;
        }
        this.cleanReportPluginsFromConfiguration((ConfigurationContainer)sitePlugin);
        if (sitePlugin != null) {
            for (PluginExecution pluginExecution : sitePlugin.getExecutions()) {
                this.cleanReportPluginsFromConfiguration((ConfigurationContainer)pluginExecution);
            }
        }
        return sitePlugin;
    }

    void cleanReportPluginsFromConfiguration(ConfigurationContainer configurationContainer) {
        if (configurationContainer == null) {
            return;
        }
        if (configurationContainer.getConfiguration() != null) {
            Xpp3Dom dom = (Xpp3Dom)configurationContainer.getConfiguration();
            for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                Xpp3Dom child = dom.getChild(i);
                if (!"reportPlugins".equals(child.getName())) continue;
                dom.removeChild(i);
            }
        }
    }

    private void setupMaven33DistributionManagement(MavenProject mavenProject) {
        if (mavenProject.getDistributionManagementArtifactRepository() == null && mavenProject.getDistributionManagement() != null) {
            if (mavenProject.getDistributionManagement().getSnapshotRepository() != null) {
                mavenProject.setSnapshotArtifactRepository(this.createRepo(mavenProject.getDistributionManagement().getSnapshotRepository()));
            }
            if (mavenProject.getDistributionManagement().getRepository() != null) {
                mavenProject.setReleaseArtifactRepository(this.createRepo(mavenProject.getDistributionManagement().getRepository()));
            }
        }
    }

    private ArtifactRepository createRepo(DeploymentRepository deploymentRepo) {
        try {
            ArtifactRepository repo = this.repositorySystem.buildArtifactRepository((Repository)deploymentRepo);
            this.repositorySystem.injectProxy(this.mavenSession.getRepositorySession(), Arrays.asList(repo));
            this.repositorySystem.injectAuthentication(this.mavenSession.getRepositorySession(), Arrays.asList(repo));
            return repo;
        }
        catch (InvalidRepositoryException e) {
            throw new IllegalStateException("Failed to create distribution repository " + deploymentRepo.getId() + " for " + this.mavenProject.getId(), e);
        }
    }

    private void fillMixins(List<Mixin> mixinList, Map<String, Mixin> mixinMap, Model model) throws MavenExecutionException {
        Properties origProperties = (model = model.clone()).getProperties() != null ? model.getProperties() : new Properties();
        origProperties.putAll((Map<?, ?>)this.mavenProject.getProperties());
        model.setProperties(origProperties);
        MixinModelProblemCollector problems = new MixinModelProblemCollector();
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest((ModelBuildingRequest)this.modelBuildingRequest);
        request.setSystemProperties(this.mavenSession.getSystemProperties());
        request.setUserProperties(this.mavenSession.getUserProperties());
        this.modelInterpolator.interpolateModel(model, this.mavenProject.getBasedir(), (ModelBuildingRequest)request, (ModelProblemCollector)problems);
        if (model.getBuild() == null) {
            model.setBuild(new Build());
        }
        List plugins = model.getBuild().getPlugins();
        for (Plugin plugin : plugins) {
            if (!plugin.getGroupId().equals(PLUGIN_GROUPID) || !plugin.getArtifactId().equals(PLUGIN_ARTIFACTID)) continue;
            Mixins mixins = this.loadConfiguration(plugin.getConfiguration());
            for (Mixin mixin : mixins.getMixins()) {
                if (mixinMap.containsKey(mixin.getKey())) continue;
                this.logger.debug(String.format("Adding mixin: %s to cache", mixin.getKey()));
                this.mixinModelCache.getModel(mixin, this.mavenProject);
                mixinMap.put(mixin.getKey(), mixin);
                mixinList.add(mixin);
            }
            for (Mixin mixin : mixins.getMixins()) {
                if (!mixin.isRecurse()) continue;
                Model mixinModel = this.mixinModelCache.getModel(mixin, this.mavenProject);
                this.fillMixins(mixinList, mixinMap, mixinModel);
            }
        }
    }

    private DefaultProfileActivationContext getProfileActivationContext() {
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        ArrayList<String> activeProfileIds = new ArrayList<String>();
        ArrayList<String> inactiveProfileIds = new ArrayList<String>();
        for (Profile profile : this.mavenProject.getActiveProfiles()) {
            activeProfileIds.add(profile.getId());
        }
        activeProfileIds.addAll(this.modelBuildingRequest.getActiveProfileIds());
        for (Profile profile : this.mavenProject.getModel().getProfiles()) {
            if (profile.getActivation() == null || activeProfileIds.contains(profile.getId())) continue;
            inactiveProfileIds.add(profile.getId());
        }
        inactiveProfileIds.addAll(this.modelBuildingRequest.getInactiveProfileIds());
        context.setActiveProfileIds(activeProfileIds);
        context.setInactiveProfileIds(inactiveProfileIds);
        context.setSystemProperties(this.mavenSession.getSystemProperties());
        context.setUserProperties(this.mavenSession.getUserProperties());
        context.setProjectDirectory(this.mavenProject.getBasedir());
        return context;
    }

    private Mixins loadConfiguration(Object configuration) throws MavenExecutionException {
        Mixins mixins = new Mixins();
        DefaultBeanConfigurationRequest request = new DefaultBeanConfigurationRequest();
        request.setBean((Object)mixins);
        request.setConfiguration(configuration, "mixins");
        try {
            this.beanConfigurator.configureBean((BeanConfigurationRequest)request);
            return mixins;
        }
        catch (BeanConfigurationException e) {
            throw new MavenExecutionException("Cannot load mixins configuration: " + e.getMessage(), (Throwable)e);
        }
    }
}

