/*
 * Decompiled with CFR 0.152.
 */
package com.github.odavid.maven.plugins;

import com.github.odavid.maven.plugins.ArtifactFetcher;
import com.github.odavid.maven.plugins.Mixin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=MixinModelCache.class)
public class MixinModelCache {
    private Map<String, Model> cache = new HashMap<String, Model>();
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactFetcher artifactFetcher;
    private MavenSession mavenSession;
    private MavenXpp3Reader xpp3Reader;

    public void init(MavenSession mavenSession, MavenXpp3Reader xpp3Reader) {
        this.mavenSession = mavenSession;
        this.xpp3Reader = xpp3Reader;
    }

    public Model getModel(Mixin mixin, MavenProject mavenProject) throws MavenExecutionException {
        Model model = this.cache.get(mixin.getKey());
        if (model == null) {
            this.checkMixinVersion(mixin, mavenProject);
            File artifactFile = null;
            for (MavenProject project : this.mavenSession.getProjects()) {
                File mixinFile;
                this.logger.debug(String.format("Checking if mixin %s is in within the same reactor", mixin));
                if (!project.getGroupId().equals(mixin.getGroupId()) || !project.getArtifactId().equals(mixin.getArtifactId()) || !mixin.getVersion().equals(project.getVersion()) || !(mixinFile = new File(project.getBasedir(), mixin.getType() + ".xml")).exists()) continue;
                artifactFile = mixinFile;
            }
            if (artifactFile == null) {
                Artifact artifact = this.getArtifact(mixin, mavenProject);
                try {
                    artifactFile = this.resolveArtifact(artifact);
                }
                catch (MojoExecutionException e) {
                    throw new MavenExecutionException(String.format("Cannot resolve mixin artifact %s", artifact), (Throwable)e);
                }
                if (artifactFile == null || !artifactFile.exists()) {
                    throw new MavenExecutionException(String.format("Cannot resolve mixin artifact %s", artifact), (Throwable)new NullPointerException());
                }
            }
            try {
                this.logger.debug(String.format("loading mixin %s locally from %s", mixin, artifactFile));
                model = this.xpp3Reader.read((InputStream)new FileInputStream(artifactFile));
                model.setVersion(mixin.getVersion());
                model.setGroupId(mixin.getGroupId());
                model.setArtifactId(mixin.getArtifactId());
                this.cache.put(mixin.getKey(), model);
            }
            catch (FileNotFoundException e) {
                throw new MavenExecutionException(String.format("Cannot find mixin file %s for mixin artifact %s ", artifactFile, mixin), (Throwable)e);
            }
            catch (IOException e) {
                throw new MavenExecutionException(String.format("Cannot read mixin file %s for mixin artifact %s ", artifactFile, mixin), (Throwable)e);
            }
            catch (XmlPullParserException e) {
                throw new MavenExecutionException(String.format("Cannot parse mixin file %s for mixin artifact %s ", artifactFile, mixin), (Throwable)e);
            }
        }
        return model;
    }

    private File resolveArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            this.artifactFetcher.resolve(artifact, this.mavenSession);
            return artifact.getFile();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(String.format("Error resolving artifact %s", new Object[]{artifact, e}));
        }
    }

    private void checkMixinVersion(Mixin mixin, MavenProject currentProject) throws MavenExecutionException {
        if (StringUtils.isEmpty((String)mixin.getVersion())) {
            String groupId = mixin.getGroupId();
            String artifactId = mixin.getArtifactId();
            String depConflictId = mixin.getKey();
            String version = mixin.getVersion();
            String type = mixin.getType();
            if (StringUtils.isEmpty((String)version)) {
                version = null;
                for (Artifact artifact : currentProject.getArtifacts()) {
                    if (!artifact.getDependencyConflictId().equals(depConflictId)) continue;
                    version = artifact.getVersion();
                    mixin.setVersion(version);
                    break;
                }
                if (version == null) {
                    for (Dependency dependency : currentProject.getDependencyManagement().getDependencies()) {
                        if (!dependency.getArtifactId().equals(artifactId) || !dependency.getGroupId().equals(groupId) || !dependency.getType().equals(type)) continue;
                        version = dependency.getVersion();
                        mixin.setVersion(version);
                        break;
                    }
                }
                if (version == null) {
                    throw new MavenExecutionException("Cannot find version for " + depConflictId, currentProject.getFile());
                }
            }
        }
    }

    private Artifact getArtifact(Mixin mixin, MavenProject currentProject) throws MavenExecutionException {
        String groupId = mixin.getGroupId();
        String artifactId = mixin.getArtifactId();
        String version = mixin.getVersion();
        String type = mixin.getType();
        return this.artifactFetcher.createArtifact(groupId, artifactId, type, null, version);
    }
}

