/*
 * Decompiled with CFR 0.152.
 */
package com.github.odavid.maven.plugins;

import com.github.odavid.maven.plugins.ArtifactFetcher;
import com.github.odavid.maven.plugins.MixinModelCache;
import com.github.odavid.maven.plugins.MixinModelMerger;
import com.github.odavid.maven.plugins.MixinsProjectLoader;
import java.util.List;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.configuration.BeanConfigurator;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.plugin.PluginConfigurationExpander;
import org.apache.maven.model.plugin.ReportingConverter;
import org.apache.maven.model.profile.ProfileInjector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="MixinMavenLifecycleParticipant")
public class MixinMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private final MavenXpp3Reader mavenXpp3reader = new MavenXpp3Reader();
    @Requirement
    private MixinModelMerger mixinModelMerger;
    @Requirement
    private Logger logger;
    @Requirement
    private BeanConfigurator beanConfigurator;
    @Requirement
    private ModelInterpolator modelInterpolator;
    @Requirement
    private PluginConfigurationExpander pluginConfigurationExpander;
    @Requirement
    private ProfileInjector profileInjector;
    @Requirement
    private ProfileSelector profileSelector;
    @Requirement
    private ArtifactFetcher artifactFetcher;
    @Requirement
    private MixinModelCache mixinModelCache;
    @Requirement
    private ReportingConverter reportingConverter;
    @Requirement
    private RepositorySystem repositorySystem;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
    }

    public void afterProjectsRead(MavenSession mavenSession) throws MavenExecutionException {
        this.logger.info(String.format("%s: Merging Mixins", "mixin-maven-plugin"));
        this.mixinModelCache.init(mavenSession, this.mavenXpp3reader);
        List projects = mavenSession.getProjects();
        for (MavenProject module : projects) {
            MixinsProjectLoader loader = new MixinsProjectLoader(mavenSession, module, this.modelInterpolator, this.pluginConfigurationExpander, this.beanConfigurator, this.logger, this.mixinModelCache, this.profileSelector, this.profileInjector, this.mixinModelMerger, this.reportingConverter, this.repositorySystem);
            loader.mergeMixins();
        }
        mavenSession.setProjects(projects);
        this.logger.info(String.format("%s: Mixins were merged", "mixin-maven-plugin"));
    }
}

