/*
 * Decompiled with CFR 0.152.
 */
package com.github.odavid.maven.plugins;

import com.github.odavid.maven.plugins.MixinModelMerger;
import com.github.odavid.maven.plugins.Mixins;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;

public class Mixin {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private Boolean mergePluginManagement;
    private Boolean mergePlugins;
    private Boolean mergeReporting;
    private Boolean mergeProperties;
    private Boolean mergeDistributionManagement;
    private Boolean mergeScm;
    private Boolean recurse;
    private Boolean activateProfiles;
    private Mixins mixins;
    private String key;

    public void setMixins(Mixins mixins) {
        this.mixins = mixins;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setRecurse(Boolean recurse) {
        this.recurse = recurse;
    }

    public void setActivateProfiles(Boolean activateProfiles) {
        this.activateProfiles = activateProfiles;
    }

    public void setMergePluginManagement(Boolean mergePluginManagement) {
        this.mergePluginManagement = mergePluginManagement;
    }

    public void setMergePlugins(Boolean mergePlugins) {
        this.mergePlugins = mergePlugins;
    }

    public void setMergeReporting(Boolean mergeReporting) {
        this.mergeReporting = mergeReporting;
    }

    public void setMergeProperties(Boolean mergeProperties) {
        this.mergeProperties = mergeProperties;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isMergePluginManagement() {
        return this.mergePluginManagement != null ? this.mergePluginManagement.booleanValue() : this.mixins.isMergePluginManagement();
    }

    public boolean isMergePlugins() {
        return this.mergePlugins != null ? this.mergePlugins.booleanValue() : this.mixins.isMergePlugins();
    }

    public boolean isMergeReporting() {
        return this.mergeReporting != null ? this.mergeReporting.booleanValue() : this.mixins.isMergeReporting();
    }

    public boolean isMergeProperties() {
        return this.mergeProperties != null ? this.mergeProperties.booleanValue() : this.mixins.isMergeProperties();
    }

    public boolean isMergeDistributionManagement() {
        return this.mergeDistributionManagement != null ? this.mergeDistributionManagement.booleanValue() : this.mixins.isMergeDistributionManagement();
    }

    public boolean isMergeScm() {
        return this.mergeScm != null ? this.mergeScm.booleanValue() : this.mixins.isMergeScm();
    }

    public boolean isRecurse() {
        return this.recurse != null ? this.recurse.booleanValue() : this.mixins.isRecurse();
    }

    public Boolean isActivateProfiles() {
        return this.activateProfiles != null ? this.activateProfiles.booleanValue() : this.mixins.isActivateProfiles();
    }

    public String getType() {
        if (this.type == null) {
            this.type = this.mixins.getDefaultMixinType();
        }
        return this.type;
    }

    public String getKey() {
        if (this.key == null) {
            this.key = this.groupId + ":" + this.artifactId + ":" + this.getType();
        }
        return this.key;
    }

    public void merge(Model mixinModel, MavenProject mavenProject, MavenSession mavenSession, MixinModelMerger mixinModelMerger) throws MavenExecutionException {
        if (this.isMergeProperties()) {
            mixinModelMerger.mergeProperties(mavenProject.getModel(), mixinModel);
        }
        if (this.isMergePluginManagement()) {
            mixinModelMerger.mergePluginManagement(mavenProject.getModel(), mixinModel);
        }
        if (this.isMergePlugins()) {
            mixinModelMerger.mergePlugins(mavenProject.getModel(), mixinModel);
        }
        if (this.isMergeReporting()) {
            mixinModelMerger.mergeReporting(mavenProject.getModel(), mixinModel);
        }
        if (this.isMergeDistributionManagement()) {
            mixinModelMerger.mergeDistributionManagement(mavenProject.getModel(), mixinModel);
        }
        if (this.isMergeScm()) {
            mixinModelMerger.mergeScm(mavenProject.getModel(), mixinModel);
        }
    }

    public String toString() {
        return this.getKey();
    }

    public void setMergeScm(Boolean mergeScm) {
        this.mergeScm = mergeScm;
    }
}

