/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr.util.histogram;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class OCRHistogram {
    public static int[] widthRowHistogram(BufferedImage image, int row, int letterHeight) {
        int width = image.getWidth();
        int height = image.getHeight();
        int black = 0;
        int[] histogram = new int[width];
        for (int i = 0; i < width; ++i) {
            for (int j = row - letterHeight / 2; j <= row + letterHeight / 2; ++j) {
                int color;
                if (j < 0 || j >= height || (color = new Color(image.getRGB(i, j)).getRed()) != black) continue;
                int n = i;
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    public static int[] histogramWithoutLetterSpaces(int[] histogram, int spaceGap) {
        int count = 0;
        for (int i = 0; i < histogram.length; ++i) {
            if (histogram[i] == 0) {
                ++count;
                continue;
            }
            if (count > 0 && count < spaceGap) {
                for (int j = i - count; j < i; ++j) {
                    histogram[j] = 1;
                }
            }
            count = 0;
        }
        return histogram;
    }
}

