/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr.util;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neuroph.ocr.util.Letter;
import org.neuroph.ocr.util.OCRUtilities;
import org.neuroph.ocr.util.WordPosition;

public class Text {
    private List<Integer> linePositions;
    private Map<Integer, List<WordPosition>> map;
    private Letter letterInfo;
    private BufferedImage image;

    public Text(BufferedImage image, Letter letterInformation) {
        this.letterInfo = letterInformation;
        this.image = image;
        this.linePositions = OCRUtilities.rowPositions(image, letterInformation.getSmallestSizeLetter());
        this.createMap();
        this.populateMap();
    }

    private void populateMap() {
        for (Integer row : this.linePositions) {
            this.map.put(row, OCRUtilities.wordsPositions(this.image, row, this.letterInfo.getLetterSize(), this.letterInfo.getSpaceGap()));
        }
    }

    private void createMap() {
        this.map = new HashMap<Integer, List<WordPosition>>();
        for (Integer row : this.linePositions) {
            this.map.put(row, new ArrayList());
        }
    }

    public int numberOfRows() {
        return this.linePositions.size();
    }

    public int getRowAt(int index) {
        return this.linePositions.get(index);
    }

    public List<WordPosition> getWordsAtRow(int index) {
        int key = this.linePositions.get(index);
        return this.map.get(key);
    }

    public List<WordPosition> getWordsAtPixel(int pixel) {
        return this.map.get(pixel);
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

