/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import org.neuroph.ocr.util.WordPosition;
import org.neuroph.ocr.util.histogram.ImageHistogram;
import org.neuroph.ocr.util.histogram.OCRHistogram;

public class OCRUtilities {
    public static String getCharacter(Map<String, Double> output) {
        double maxValue = -1.0;
        Map.Entry<String, Double> maxElement = null;
        for (Map.Entry<String, Double> element : output.entrySet()) {
            if (!(maxValue < element.getValue())) continue;
            maxElement = element;
            maxValue = element.getValue();
        }
        return (String)maxElement.getKey();
    }

    public static List<Integer> rowPositions(BufferedImage image, int heightThresh) {
        int[] histogram = ImageHistogram.histogramByHeight(image);
        int[] gradient = ImageHistogram.gradient(histogram);
        return OCRUtilities.linePositions(gradient, heightThresh);
    }

    public static List<WordPosition> wordsPositions(BufferedImage image, int row, int letterHeight, int spaceGap) {
        ArrayList<WordPosition> words = new ArrayList<WordPosition>();
        int[] histogram = OCRHistogram.widthRowHistogram(image, row, letterHeight);
        int[] histogramWLS = OCRHistogram.histogramWithoutLetterSpaces(histogram, spaceGap);
        int count = 0;
        for (int i = 0; i < histogramWLS.length; ++i) {
            if (histogramWLS[i] != 0) {
                ++count;
                continue;
            }
            if (count > 0) {
                int start = i - count;
                int end = i - 1;
                WordPosition w = new WordPosition(start, end);
                words.add(w);
            }
            count = 0;
        }
        return words;
    }

    public static void saveToFile(BufferedImage image, String path, String letterName, String extension) {
        String imagePath = path + letterName + "." + extension;
        File outputfile = new File(imagePath);
        try {
            ImageIO.write((RenderedImage)image, extension, outputfile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String createImageName(String character) {
        int number = character.hashCode() * new Random().nextInt(100);
        return character + "_" + number;
    }

    public static List<Integer> linePositions(int[] gradient, int ignoredSize) {
        ArrayList<Integer> lines = new ArrayList<Integer>();
        int sum = 0;
        int count = 0;
        for (int row = 0; row < gradient.length; ++row) {
            if ((sum += gradient[row]) != 0) {
                ++count;
                continue;
            }
            if (sum != 0) continue;
            if (count < ignoredSize) {
                count = 0;
                continue;
            }
            int startLetter = row - count;
            int endLetter = row;
            int line = (startLetter + endLetter) / 2;
            lines.add(line);
            count = 0;
        }
        return lines;
    }

    public static List<Integer> rowHeights(int[] gradient, int ignoredSize) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        int sum = 0;
        int count = 0;
        for (int row = 0; row < gradient.length; ++row) {
            if ((sum += gradient[row]) != 0) {
                ++count;
                continue;
            }
            if (sum != 0) continue;
            if (count < ignoredSize) {
                count = 0;
                continue;
            }
            heights.add(count);
            count = 0;
        }
        return heights;
    }
}

