/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr.util;

import java.awt.image.BufferedImage;
import java.util.List;
import org.neuroph.ocr.util.OCRUtilities;
import org.neuroph.ocr.util.histogram.ImageHistogram;

public class Letter {
    private int cropWidth;
    private int cropHeight;
    private int smallestSizeLetter;
    private int letterSize;
    private int trashSize;
    private int spaceGap;
    private int scanQuality;
    private int fontSize;
    private BufferedImage image;
    private int[] heightHistogram;
    private int[] gradient;

    public Letter(int scanQuality, BufferedImage image) {
        this.scanQuality = scanQuality;
        this.image = image;
        this.heightHistogram = ImageHistogram.histogramByHeight(image);
        this.gradient = ImageHistogram.gradient(this.heightHistogram);
        this.calculateSmallestSizeLetter();
        List<Integer> rowHeights = OCRUtilities.rowHeights(this.gradient, this.smallestSizeLetter);
        int meanHeight = (int)this.caluclateMean(rowHeights);
        this.calculateDimensions(meanHeight);
        this.calculateLetterSize(meanHeight);
        this.calculateSpaceGap(meanHeight);
    }

    private void calculateDimensions(int meanHeight) {
        int offset = (int)(0.1 * (double)meanHeight);
        this.cropWidth = meanHeight + offset;
        this.cropHeight = meanHeight + offset;
    }

    private void calculateSmallestSizeLetter() {
        if (this.scanQuality == 300) {
            this.smallestSizeLetter = 9;
        }
        if (this.scanQuality == 600) {
            this.smallestSizeLetter = 18;
        }
        if (this.scanQuality == 1200) {
            this.smallestSizeLetter = 36;
        }
    }

    private void calculateLetterSize(int meanHeight) {
        this.letterSize = meanHeight;
    }

    private void calculateTrashsize(int meanHeight) {
        int offset = (int)(0.1 * (double)meanHeight);
        this.trashSize = meanHeight - offset;
    }

    private void calculateSpaceGap(int meanHeight) {
        this.spaceGap = (int)(0.3 * (double)meanHeight);
    }

    public int getCropHeight() {
        return this.cropHeight;
    }

    public int getCropWidth() {
        return this.cropWidth;
    }

    public int getLetterSize() {
        return this.letterSize;
    }

    public int getSmallestSizeLetter() {
        return this.smallestSizeLetter;
    }

    public int getTrashSize() {
        return this.trashSize;
    }

    public int getSpaceGap() {
        return this.spaceGap;
    }

    public int getScanQuality() {
        return this.scanQuality;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setCropHeight(int cropHeight) {
        this.cropHeight = cropHeight;
    }

    public void setCropWidth(int cropWidth) {
        this.cropWidth = cropWidth;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setLetterSize(int letterSize) {
        this.letterSize = letterSize;
    }

    public void setSmallestSizeLetter(int smallestSizeLetter) {
        this.smallestSizeLetter = smallestSizeLetter;
    }

    public void setSpaceGap(int spaceGap) {
        this.spaceGap = spaceGap;
    }

    public void setTrashSize(int trashSize) {
        this.trashSize = trashSize;
    }

    private double caluclateMean(List<Integer> list) {
        double sum = 0.0;
        for (Integer element : list) {
            sum += (double)element.intValue();
        }
        return sum / (double)list.size();
    }
}

