/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr.samples;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.imgrec.ColorMode;
import org.neuroph.imgrec.ImageRecognitionHelper;
import org.neuroph.imgrec.filter.ImageFilter;
import org.neuroph.imgrec.filter.ImageFilterChain;
import org.neuroph.imgrec.filter.impl.GrayscaleFilter;
import org.neuroph.imgrec.filter.impl.OtsuBinarizeFilter;
import org.neuroph.imgrec.image.Dimension;
import org.neuroph.nnet.learning.BackPropagation;
import org.neuroph.ocr.OCRTraining;
import org.neuroph.ocr.util.Letter;
import org.neuroph.ocr.util.Text;
import org.neuroph.util.TransferFunctionType;

public class TrainingSample {
    public static void main(String[] args) throws IOException {
        String imagePath = "C:/Users/Mihailo/Desktop/OCR/slova.png";
        String folderPath = "C:/Users/Mihailo/Desktop/OCR/ImagesDir/";
        String textPath = "C:/Users/Mihailo/Desktop/OCR/slova.txt";
        String networkPath = "C:/Users/Mihailo/Desktop/OCR/network.nnet";
        int fontSize = 12;
        int scanQuality = 300;
        BufferedImage image = ImageIO.read(new File(imagePath));
        ImageFilterChain chain = new ImageFilterChain();
        chain.addFilter((ImageFilter)new GrayscaleFilter());
        chain.addFilter((ImageFilter)new OtsuBinarizeFilter());
        BufferedImage binarizedImage = chain.apply(image);
        Letter letterInfo = new Letter(scanQuality, binarizedImage);
        Text texTInfo = new Text(binarizedImage, letterInfo);
        OCRTraining ocrTraining = new OCRTraining(letterInfo, texTInfo);
        ocrTraining.setFolderPath(folderPath);
        ocrTraining.setTrainingTextPath(textPath);
        ocrTraining.prepareTrainingSet();
        List<String> characterLabels = ocrTraining.getCharacterLabels();
        Map map = ImageRecognitionHelper.getFractionRgbDataForDirectory((File)new File(folderPath), (Dimension)new Dimension(20, 20));
        DataSet dataSet = ImageRecognitionHelper.createBlackAndWhiteTrainingSet(characterLabels, (Map)map);
        dataSet.setFilePath("C:/Users/Mihailo/Desktop/OCR/DataSet1.tset");
        dataSet.save();
        ArrayList<Integer> hiddenLayers = new ArrayList<Integer>();
        hiddenLayers.add(12);
        NeuralNetwork nnet = ImageRecognitionHelper.createNewNeuralNetwork((String)"someNetworkName", (Dimension)new Dimension(20, 20), (ColorMode)ColorMode.BLACK_AND_WHITE, characterLabels, hiddenLayers, (TransferFunctionType)TransferFunctionType.SIGMOID);
        BackPropagation bp = (BackPropagation)nnet.getLearningRule();
        bp.setLearningRate(0.3);
        bp.setMaxError(0.1);
        System.out.println("Start learning...");
        nnet.learn(dataSet);
        System.out.println("NNet learned");
        nnet.save(networkPath);
    }
}

