/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr.samples;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.neuroph.imgrec.filter.ImageFilter;
import org.neuroph.imgrec.filter.ImageFilterChain;
import org.neuroph.imgrec.filter.impl.GrayscaleFilter;
import org.neuroph.imgrec.filter.impl.OtsuBinarizeFilter;
import org.neuroph.ocr.OCRTextRecognition;
import org.neuroph.ocr.util.Letter;
import org.neuroph.ocr.util.Text;

public class RecognitionSample {
    public static void main(String[] args) throws IOException {
        String imagePath = "C:/Users/Mihailo/Desktop/OCR/tekst.png";
        String textPath = "C:/Users/Mihailo/Desktop/OCR/tekst.txt";
        String networkPath = "C:/Users/Mihailo/Desktop/OCR/network.nnet";
        int fontSize = 12;
        int scanQuality = 300;
        BufferedImage image = ImageIO.read(new File(imagePath));
        ImageFilterChain chain = new ImageFilterChain();
        chain.addFilter((ImageFilter)new GrayscaleFilter());
        chain.addFilter((ImageFilter)new OtsuBinarizeFilter());
        BufferedImage binarizedImage = chain.apply(image);
        Letter letterInfo = new Letter(scanQuality, binarizedImage);
        Text textInfo = new Text(binarizedImage, letterInfo);
        OCRTextRecognition recognition = new OCRTextRecognition(letterInfo, textInfo);
        recognition.setNetworkPath(networkPath);
        recognition.recognize();
        System.out.println(recognition.getRecognizedText());
    }
}

