/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr.filter;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.LinkedList;

public class OCRExtractLetter {
    private int cropWidth;
    private int cropHeight;
    private int trashSize;

    public OCRExtractLetter(int cropWidth, int cropHeight, int trashSize) {
        this.cropWidth = cropWidth;
        this.cropHeight = cropHeight;
        this.trashSize = trashSize;
    }

    public OCRExtractLetter() {
    }

    public void setCropHeight(int cropHeight) {
        this.cropHeight = cropHeight;
    }

    public void setCropWidth(int cropWidth) {
        this.cropWidth = cropWidth;
    }

    public void setTrashSize(int trashSize) {
        this.trashSize = trashSize;
    }

    public BufferedImage extraxtLetter(BufferedImage image, boolean[][] visited, int startX, int startY) {
        int gapWidth = this.cropWidth / 5 * 2;
        int gapHeight = this.cropHeight / 5 * 2;
        LinkedList<String> queue = new LinkedList<String>();
        BufferedImage letter = new BufferedImage(this.cropWidth, this.cropHeight, image.getType());
        Color white = Color.WHITE;
        Color black = Color.BLACK;
        for (int i = 0; i < this.cropHeight; ++i) {
            for (int j = 0; j < this.cropWidth; ++j) {
                letter.setRGB(j, i, white.getRGB());
            }
        }
        int countPixels = 0;
        String positions = startX + " " + startY;
        visited[startX][startY] = true;
        queue.addLast(positions);
        while (!queue.isEmpty()) {
            String pos = (String)queue.removeFirst();
            String[] posArray = pos.split(" ");
            int H = Integer.parseInt(posArray[0]);
            int W = Integer.parseInt(posArray[1]);
            visited[H][W] = true;
            int posW = W - startY + gapWidth;
            int posH = H - startX + gapHeight;
            ++countPixels;
            letter.setRGB(posW, posH, black.getRGB());
            int blackInt = 0;
            for (int i = H - 1; i <= H + 1; ++i) {
                for (int j = W - 1; j <= W + 1; ++j) {
                    int color;
                    if (i < 0 || j < 0 || i >= image.getHeight() || j >= image.getWidth() || visited[i][j] || (color = new Color(image.getRGB(j, i)).getRed()) != blackInt) continue;
                    visited[i][j] = true;
                    String tmpPos = i + " " + j;
                    queue.addLast(tmpPos);
                }
            }
        }
        if (countPixels < this.trashSize) {
            return null;
        }
        return letter;
    }
}

