/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.ocr;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.neuroph.ocr.filter.OCRCropLetter;
import org.neuroph.ocr.filter.OCRExtractLetter;
import org.neuroph.ocr.properties.OCRProperties;
import org.neuroph.ocr.util.Letter;
import org.neuroph.ocr.util.OCRUtilities;
import org.neuroph.ocr.util.Text;

public class OCRTraining
extends OCRProperties {
    private String folderPath;
    private String trainingText;
    private String imageExtension = "png";
    private List<String> characterLabels;

    public OCRTraining(Letter letterInformation, Text textInformation) {
        super(letterInformation, textInformation);
    }

    public void setTrainingTextPath(String trainingTextPath) {
        try {
            Path path = FileSystems.getDefault().getPath(trainingTextPath, new String[0]);
            this.trainingText = new String(Files.readAllBytes(path));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setFolderPath(String lettersPath) {
        this.folderPath = lettersPath;
    }

    public void setImageExtension(String imageExtension) {
        this.imageExtension = imageExtension;
    }

    public String getTrainingText() {
        return this.trainingText;
    }

    public void setTrainingText(String trainingText) {
        this.trainingText = trainingText;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public List<String> getCharacterLabels() {
        return this.characterLabels;
    }

    public void prepareTrainingSet() {
        this.prepateText();
        this.createCharacterLabels();
        this.createImagesWithLetters();
    }

    private void createCharacterLabels() {
        this.characterLabels = new ArrayList<String>();
        for (int i = 0; i < this.trainingText.length(); ++i) {
            String c = this.trainingText.charAt(i) + "";
            if (this.characterLabels.contains(c)) continue;
            this.characterLabels.add(this.trainingText.charAt(i) + "");
        }
    }

    private void prepateText() {
        String tmp = "";
        for (int i = 0; i < this.trainingText.length(); ++i) {
            char c = this.trainingText.charAt(i);
            if (Character.isSpaceChar(c) || Character.isWhitespace(c)) continue;
            tmp = tmp + c;
        }
        this.trainingText = tmp;
    }

    private void createImagesWithLetters() {
        int cropWidth = this.letterInformation.getCropWidth();
        int cropHeight = this.letterInformation.getCropHeight();
        int tmpWidth = 3 * cropWidth;
        int tmpHeight = 3 * cropHeight;
        int trashSize = this.letterInformation.getTrashSize();
        OCRExtractLetter extractionLetter = new OCRExtractLetter(tmpWidth, tmpHeight, trashSize);
        int letterSize = this.letterInformation.getLetterSize();
        int imageHeight = this.image.getHeight();
        int imageWidth = this.image.getWidth();
        boolean[][] visited = new boolean[imageHeight][imageWidth];
        Color white = Color.WHITE;
        int seqNum = 0;
        for (int line = 0; line < this.textInformation.numberOfRows(); ++line) {
            for (int j = 0; j < imageWidth; ++j) {
                for (int k = -(letterSize / 4); k < letterSize / 4; ++k) {
                    BufferedImage letter;
                    int rowPixel = this.textInformation.getRowAt(line);
                    int i = rowPixel + k;
                    if (i < 0 || i >= imageHeight) continue;
                    Color color = new Color(this.image.getRGB(j, i));
                    if (color.equals(white)) {
                        visited[i][j] = true;
                        continue;
                    }
                    if (visited[i][j] || (letter = extractionLetter.extraxtLetter(this.image, visited, i, j)) == null) continue;
                    OCRCropLetter crop = new OCRCropLetter(letter, cropWidth, cropHeight);
                    BufferedImage croped = crop.processImage();
                    String character = this.trainingText.charAt(seqNum) + "";
                    String name = character + "_" + seqNum;
                    OCRUtilities.saveToFile(croped, this.folderPath, name, this.imageExtension);
                    ++seqNum;
                }
            }
        }
    }
}

