/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.neuroph.imgrec.image.Image;

public class ImageAndroid
implements Image {
    private Bitmap bitmap;

    public ImageAndroid(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    private ImageAndroid(int width, int height, int imageType) {
        this.bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)this.imageTypeToBitmapConfig(imageType));
    }

    private ImageAndroid(File imageFile) {
        this.bitmap = BitmapFactory.decodeFile((String)imageFile.getAbsolutePath());
    }

    private ImageAndroid(String filePath) {
        this.bitmap = BitmapFactory.decodeFile((String)filePath);
    }

    private ImageAndroid(URL imageUrl) throws IOException {
        this.bitmap = BitmapFactory.decodeStream((InputStream)((InputStream)imageUrl.getContent()));
    }

    @Override
    public int getPixel(int x, int y) {
        return this.bitmap.getPixel(x, y);
    }

    @Override
    public void setPixel(int x, int y, int color) {
        this.bitmap.setPixel(x, y, color);
    }

    @Override
    public int[] getPixels(int offset, int stride, int x, int y, int width, int height) {
        int[] pixels = new int[width * height];
        this.bitmap.getPixels(pixels, offset, stride, x, y, width, height);
        return pixels;
    }

    @Override
    public void setPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.bitmap.setPixels(pixels, offset, stride, x, y, width, height);
    }

    @Override
    public int getWidth() {
        return this.bitmap.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bitmap.getHeight();
    }

    @Override
    public Image resize(int width, int height) {
        this.bitmap = Bitmap.createScaledBitmap((Bitmap)this.bitmap, (int)width, (int)height, (boolean)true);
        return new ImageAndroid(this.bitmap);
    }

    @Override
    public Image crop(int x1, int y1, int x2, int y2) {
        return new ImageAndroid(Bitmap.createBitmap((Bitmap)this.bitmap, (int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1)));
    }

    private Bitmap.Config imageTypeToBitmapConfig(int imageType) throws IllegalArgumentException {
        Bitmap.Config bitmapConfig = null;
        switch (imageType) {
            case 14: {
                bitmapConfig = Bitmap.Config.ALPHA_8;
                break;
            }
            case 15: {
                bitmapConfig = Bitmap.Config.ARGB_8888;
                break;
            }
            case 16: {
                bitmapConfig = Bitmap.Config.RGB_565;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal image type, image type: " + imageType);
            }
        }
        return bitmapConfig;
    }

    @Override
    public int getType() {
        return 14;
    }
}

