/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class SobelEdgeDetection
implements ImageFilter<BufferedImage>,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private double[][] horizSobel;
    private double[][] vertSobel;
    private double threshold;
    public static final int WHITE = 255;
    public static final int BLACK = 0;

    public SobelEdgeDetection() {
        this.initSobelFilters();
        this.threshold = 0.1;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        this.originalImage = image;
        int width = image.getWidth();
        int height = image.getHeight();
        this.filteredImage = new BufferedImage(width, height, image.getType());
        double[][] gradX = new double[width][height];
        double[][] gradY = new double[width][height];
        double[][] grad = new double[width][height];
        double maxGrad = 0.0;
        for (int x = 1; x < width - 1; ++x) {
            for (int y = 1; y < height - 1; ++y) {
                gradX[x][y] = this.applyFilter(x, y, this.horizSobel);
                gradY[x][y] = this.applyFilter(x, y, this.vertSobel);
                grad[x][y] = Math.abs(gradX[x][y]) + Math.abs(gradY[x][y]);
                if (!(grad[x][y] > maxGrad)) continue;
                maxGrad = grad[x][y];
            }
        }
        this.threshold *= maxGrad;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int alpha = new Color(this.originalImage.getRGB(x, y)).getAlpha();
                int newPixelColor = grad[x][y] > this.threshold ? 0 : 255;
                int rgb = ImageUtilities.argbToColor(alpha, newPixelColor, newPixelColor, newPixelColor);
                this.filteredImage.setRGB(x, y, rgb);
            }
        }
        return this.filteredImage;
    }

    private void initSobelFilters() {
        this.horizSobel = new double[3][3];
        this.horizSobel[0][0] = -1.0;
        this.horizSobel[0][1] = -2.0;
        this.horizSobel[0][2] = -1.0;
        this.horizSobel[1][0] = 0.0;
        this.horizSobel[1][1] = 0.0;
        this.horizSobel[1][2] = 0.0;
        this.horizSobel[2][0] = 1.0;
        this.horizSobel[2][1] = 2.0;
        this.horizSobel[2][2] = 1.0;
        this.vertSobel = new double[3][3];
        this.vertSobel[0][0] = -1.0;
        this.vertSobel[0][1] = 0.0;
        this.vertSobel[0][2] = 1.0;
        this.vertSobel[1][0] = -2.0;
        this.vertSobel[1][1] = 0.0;
        this.vertSobel[1][2] = 2.0;
        this.vertSobel[2][0] = -1.0;
        this.vertSobel[2][1] = 0.0;
        this.vertSobel[2][2] = 1.0;
    }

    protected double applyFilter(int xCenter, int yCenter, double[][] sobelFilter) {
        double filterSum = 0.0;
        int fx = 0;
        for (int x = xCenter - 1; x <= xCenter + 1; ++x) {
            int fy = 0;
            for (int y = yCenter - 1; y <= yCenter + 1; ++y) {
                double pixelGray = new Color(this.originalImage.getRGB(x, y)).getRed();
                filterSum += pixelGray * sobelFilter[fx][fy];
                ++fy;
            }
            ++fx;
        }
        return filterSum;
    }

    public void setTreshold(double treshold) {
        this.threshold = treshold;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public String toString() {
        return "Sobel method";
    }
}

