/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class OtsuBinarizeFilter
implements ImageFilter<BufferedImage>,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private static final int BLACK_PIXEL = 0;
    private static final int WHITE_PIXEL = 255;

    @Override
    public BufferedImage apply(BufferedImage image) {
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        int[] histogram = this.imageHistogram(this.originalImage);
        int totalNumberOfpixels = width * height;
        int threshold = this.calculateThreshold(histogram, totalNumberOfpixels);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                Color col = new Color(this.originalImage.getRGB(x, y));
                int gray = col.getRed();
                int alpha = col.getAlpha();
                int newColor = gray > threshold ? 255 : 0;
                newColor = ImageUtilities.argbToColor(alpha, newColor, newColor, newColor);
                this.filteredImage.setRGB(x, y, newColor);
            }
        }
        return this.filteredImage;
    }

    private int[] imageHistogram(BufferedImage image) {
        int[] histogram = new int[256];
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int gray;
                int n = gray = image.getRGB(x, y) >> 16 & 0xFF;
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    private int calculateThreshold(int[] histogram, int total) {
        float sum = 0.0f;
        for (int i = 0; i < 256; ++i) {
            sum += (float)(i * histogram[i]);
        }
        float sumB = 0.0f;
        int wB = 0;
        int wF = 0;
        float varMax = 0.0f;
        int threshold = 0;
        for (int i = 0; i < 256; ++i) {
            float mF;
            float varBetween;
            if ((wB += histogram[i]) == 0) continue;
            wF = total - wB;
            if (wF == 0) break;
            float mB = (sumB += (float)(i * histogram[i])) / (float)wB;
            if (!((varBetween = (float)wB * (float)wF * (mB - (mF = (sum - sumB) / (float)wF)) * (mB - mF)) > varMax)) continue;
            varMax = varBetween;
            threshold = i;
        }
        return threshold;
    }

    public String toString() {
        return "Otsu Binarize Filter";
    }
}

