/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;
import org.neuroph.imgrec.filter.impl.OCRCropImage;

public class OCRSeparationFilter
implements ImageFilter<BufferedImage> {
    private BufferedImage originalImage;
    private int width;
    private int height;
    private int cropHeight = 0;
    private int cropWidth = 0;
    private boolean[][] visited;
    private int letterWidth = 0;
    private int letterHeight = 0;
    private String location;
    private int[] counts;
    private int[] linePositions = null;
    private String text;
    private int seqNum = 0;

    @Override
    public BufferedImage apply(BufferedImage image) {
        this.originalImage = image;
        this.width = this.originalImage.getWidth();
        this.height = this.originalImage.getHeight();
        this.prepare();
        this.visited = new boolean[this.height][this.width];
        int white = 255;
        for (int line = 0; line < this.linePositions.length; ++line) {
            for (int k = -1; k <= 1; ++k) {
                int i = this.linePositions[line] + k;
                if (i == -1 || i == this.height) continue;
                for (int j = 0; j < this.width; ++j) {
                    int color = new Color(this.originalImage.getRGB(j, i)).getRed();
                    if (color == white) {
                        this.visited[i][j] = true;
                        continue;
                    }
                    this.BFStraverseAndSave(i, j);
                }
            }
        }
        return this.originalImage;
    }

    private void BFStraverseAndSave(int startI, int startJ) {
        int gapWidth = this.letterWidth / 5 * 2;
        int gapHeight = this.letterHeight / 5 * 2;
        LinkedList<String> queue = new LinkedList<String>();
        BufferedImage letter = new BufferedImage(this.letterWidth, this.letterHeight, this.originalImage.getType());
        int alpha = new Color(this.originalImage.getRGB(startJ, startI)).getAlpha();
        int white = ImageUtilities.argbToColor(alpha, 255, 255, 255);
        int black = ImageUtilities.argbToColor(alpha, 0, 0, 0);
        for (int i = 0; i < this.letterHeight; ++i) {
            for (int j = 0; j < this.letterWidth; ++j) {
                letter.setRGB(j, i, white);
            }
        }
        int countPixels = 0;
        String positions = startI + " " + startJ;
        this.visited[startI][startJ] = true;
        queue.addLast(positions);
        while (!queue.isEmpty()) {
            String pos = (String)queue.removeFirst();
            String[] posArray = pos.split(" ");
            int H = Integer.parseInt(posArray[0]);
            int W = Integer.parseInt(posArray[1]);
            this.visited[H][W] = true;
            int posW = W - startJ + gapWidth;
            int posH = H - startI + gapHeight;
            ++countPixels;
            letter.setRGB(posW, posH, black);
            int blackInt = 0;
            for (int i = H - 1; i <= H + 1; ++i) {
                for (int j = W - 1; j <= W + 1; ++j) {
                    int color;
                    if (i < 0 || j < 0 || i >= this.originalImage.getHeight() || j >= this.originalImage.getWidth() || this.visited[i][j] || (color = new Color(this.originalImage.getRGB(j, i)).getRed()) != blackInt) continue;
                    this.visited[i][j] = true;
                    String tmpPos = i + " " + j;
                    queue.addLast(tmpPos);
                }
            }
        }
        if (countPixels < 35) {
            return;
        }
        String name = this.createName();
        this.saveToFile(letter, name);
        ++this.seqNum;
    }

    private void saveToFile(BufferedImage img, String letterName) {
        File outputfile = new File(this.location + letterName + ".png");
        BufferedImage crop = img;
        if (this.cropHeight != 0 || this.cropWidth != 0) {
            OCRCropImage ci = new OCRCropImage();
            ci.setDimension(this.cropWidth, this.cropHeight);
            crop = ci.apply(img);
        }
        try {
            ImageIO.write((RenderedImage)crop, "png", outputfile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void prepare() {
        int i;
        this.counts = new int[52];
        for (int i2 = 0; i2 < this.counts.length; ++i2) {
            this.counts[i2] = 1;
        }
        String pom = "";
        for (i = 0; i < this.text.length(); ++i) {
            if (!Character.isLetter(this.text.charAt(i))) continue;
            pom = pom + this.text.charAt(i);
        }
        this.text = pom;
        if (this.linePositions == null) {
            this.linePositions = new int[this.height];
            for (i = 0; i < this.linePositions.length; ++i) {
                this.linePositions[i] = i;
            }
        }
    }

    private String createName() {
        int number;
        int offsetBIG = 65;
        int offsetSMALL = 97;
        int offsetARRAY = 26;
        char c = this.text.charAt(this.seqNum);
        char key = c;
        if (key < '_') {
            number = this.counts[key - offsetBIG];
            int n = key - offsetBIG;
            this.counts[n] = this.counts[n] + 1;
        } else {
            number = this.counts[key - offsetSMALL + offsetARRAY];
            int n = key - offsetSMALL + offsetARRAY;
            this.counts[n] = this.counts[n] + 1;
        }
        String name = c + "_" + number;
        return name;
    }

    public void setLinePositions(int[] linePositions) {
        this.linePositions = linePositions;
    }

    public void setDimension(int cropHeight, int cropWidth) {
        this.cropHeight = cropHeight;
        this.cropWidth = cropWidth;
        this.letterWidth = 3 * cropWidth;
        this.letterHeight = 3 * cropHeight;
    }

    public void setLocationFolder(String location) {
        this.location = location;
    }

    public void setText(String text) {
        this.text = text;
    }
}

